<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="3.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:ct="http://v_20_0/types/CommonTypes.xsd"
    xmlns:cf="http://v_20_0/idActs/AZOUT.xsd">
    <xsl:output method="html" omit-xml-declaration="yes" />
    <xsl:param name="version" select="'1.0'"/>

    <xsl:template match="/">
        <xsl:apply-templates select="/cf:azout" />
    </xsl:template>

    <xsl:template match="/cf:azout">
        <html>
            <head>
                <style type="text/css">
                    h1 {
                    font-family: Times New Roman;
                    font-size: 14pt;
                    text-align:center;
                    font-weight: bold;
                    width: 100%;
                    margin-top: 0px;
                    }
                    h2 {
                    font-family: Times New Roman;
                    font-size: 12pt;
                    font-weight: bold;
                    width: 100%;
                    margin-top: 0px;
                    }
                    h3 {
                    font-family: Times New Roman;
                    font-size: 12pt;
                    text-align:center;
                    font-weight: bold;
                    width: 100%;
                    margin-top: 0px;
                    }
                    p {
                    font-family: Times New Roman;
                    font-size: 14pt;
                    margin-bottom: 5px;
                    text-indent: 0px;
                    margin-top: 0;
                    text-align: justify;
                    }
                    body {
                    font-family: Times New Roman;
                    font-size: 14pt;
                    margin: 0 auto;
                    padding: 10px;
                    max-width:1200
                    }
                    .under {
                    line-height: 0.9em;
                    margin:0cm;
                    margin-bottom:.0001pt;
                    text-autospace:none;
                    font-size:10.0pt;
                    font-family:"Times New Roman",serif;
                    margin-bottom:12.0pt;
                    text-align:center;
                    border:none;
                    }
                    .data {
                    margin-bottom:1.0pt;
                    font-family: Times New Roman;
                    font-style: italic;
                    border-bottom: 1px solid;
                    font-size: 10pt;
                    text-align: center;
                    }
                    .list {
                    font-size: 12pt;
                    }
                    .str {
                    display: flex;
                    flex-wrap: wrap;  
                    }
                    .col {
                    width:40%;
                    display: flex;
                    flex-direction:column;
                    gap: 5pt;
                    }
                </style>
                <title>Акт на засыпку (обваловку) уложенного трубопровода</title>
            </head>
            <body>
                <xsl:for-each select="cf:actInfo">
                    <div style="display: flex; justify-content: space-between;">
                        <div class="col">
                            <div>
                                <p class="list">Заказчик</p>
                                <p class="data">
                                    <xsl:choose>
                                        <xsl:when test="cf:participantDeveloper">
                                            <xsl:for-each select="cf:participantDeveloper">
                                                <xsl:call-template name="orgTempl">
                                                    <xsl:with-param name="Org" select="." />
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:when>
                                        <xsl:when test="cf:participantTechnicalCustomer">
                                            <xsl:for-each select="cf:participantTechnicalCustomer">
                                                <xsl:call-template name="orgTempl">
                                                    <xsl:with-param name="Org" select="." />
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:when>
                                        <xsl:when test="cf:participantBuildingOperator">
                                            <xsl:for-each select="cf:participantBuildingOperator">
                                                <xsl:call-template name="orgTempl">
                                                    <xsl:with-param name="Org" select="." />
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:when>
                                        <xsl:when test="cf:participantRegionalBuildingOperator">
                                            <xsl:for-each select="cf:participantRegionalBuildingOperator">
                                                <xsl:call-template name="orgTempl">
                                                    <xsl:with-param name="Org" select="." />
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:when>
                                    </xsl:choose>
                                </p>
                            </div>
                            <div>
                                <xsl:choose>
                                    <xsl:when test="cf:participantWorkExecutor">
                                        <p class="list">Подрядчик </p>
                                        <p class="data">
                                            <xsl:for-each select="cf:participantWorkExecutor">
                                                <xsl:call-template name="orgTempl">
                                                    <xsl:with-param name="Org" select="." />
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </p>
                                    </xsl:when>
                                    <xsl:when test="not(cf:participantWorkExecutor)">
                                        <p class="list">Генподрядчик </p>
                                        <p class="data">
                                            <xsl:for-each select="cf:participantBuildingContractor">
                                                <xsl:call-template name="orgTempl">
                                                    <xsl:with-param name="Org" select="." />
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </p>
                                    </xsl:when>
                                </xsl:choose>
                            </div>
                            <div>
                                <p class="list">Участок </p>
                                <p class="data">
                                    <xsl:choose>
                                        <xsl:when test="cf:workSector">
                                            <xsl:value-of select="cf:workSector" />
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>&#160;</xsl:text>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </p>
                            </div>
                        </div>
                        <div class="col">
                            <div>
                                <p class="list">Основание</p>
                                <p class="data">ВСН 012-88 (ЧастьII) Миннефтегазстрой</p>
                            </div>
                            <div>
                                <p class="list">Строительство </p>
                                <p class="data"><xsl:value-of select="cf:permanentObjectInfo/ct:permanentObjectName" /></p>
                            </div>
                            <div>
                                <p class="list">Объект </p>
                                <p class="data"><xsl:value-of select="cf:permanentObjectPart" /></p>
                            </div>
                        </div>
                    </div>
                    <br/>
                    <h1>АКТ
                        <xsl:choose>
                            <xsl:when test="cf:documentDetails/ct:structureElementNumber">
                                № <xsl:value-of select="cf:documentDetails/ct:structureElementNumber"/>
                            </xsl:when>
                            <xsl:otherwise>
                                № <xsl:value-of select="cf:documentDetails/ct:number" />
                            </xsl:otherwise>
                        </xsl:choose>
                        <br/>на засыпку (обваловку) уложенного трубопровода</h1>
                    <div style="display: flex; justify-content: end; align-items: start;">
                        <p class="data">
                            <xsl:call-template name="formatdate">
                                <xsl:with-param name="DateStr" select="cf:documentDetails/ct:date" />
                            </xsl:call-template>
                        </p>
                    </div>
                    <p class="list">Мы, нижеподписавшиеся: </p>
                    <div style="display: flex; align-items:baseline ; width: 100%; ">
                        <div>
                            <p class="list">представителя заказчика </p>
                        </div>
                        <div style="flex: 2;">
                            <xsl:choose>
                                <xsl:when test="cf:representativeDeveloperControl">
                                    <xsl:for-each select="cf:representativeDeveloperControl">
                                        <xsl:call-template name="representative"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="cf:representativeTechnicalCustomerControl">
                                    <xsl:for-each select="cf:representativeTechnicalCustomerControl">
                                        <xsl:call-template name="representative"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="cf:representativeBuildingOperatorControl">
                                    <xsl:for-each select="cf:representativeBuildingOperatorControl">
                                        <xsl:call-template name="representative"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="cf:representativeRegionalBuildingOperatorControl">
                                    <xsl:for-each select="cf:representativeRegionalBuildingOperatorControl">
                                        <xsl:call-template name="representative"/>
                                    </xsl:for-each>
                                </xsl:when>
                            </xsl:choose>
                            <p class="under">(должность, фамилия, инициалы)</p>
                        </div>
                    </div>
                    <div style="display: flex; align-items:baseline ; width: 100%;">
                        <div>
                            <p class="list">и производитель работ </p>
                        </div>
                        <div style="flex: 2;">
                            <xsl:choose>
                                <xsl:when test="cf:representativeWorkExecutor">
                                    <xsl:for-each select="cf:representativeWorkExecutor">
                                        <xsl:call-template name="representative"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="not(cf:representativeWorkExecutor)">
                                    <xsl:for-each select="cf:representativeBuildingContractor">
                                        <xsl:call-template name="representative"/>
                                    </xsl:for-each>
                                </xsl:when>
                            </xsl:choose>
                            <p class="under">(должность, фамилия, инициалы)</p>
                        </div>
                    </div>
                    <p class="list">составили настоящий акт в том, что на участке <span class="data"><xsl:value-of select="cf:pipelineType" /></span> общей протяженностью
                        <span class="data"><xsl:value-of select="cf:totalPipelineLength/ct:value" /><xsl:text> </xsl:text><xsl:value-of select="cf:totalPipelineLength/ct:unit" /></span>
                    </p>
                    <xsl:for-each select="cf:projectCompliantBackfillSectionList/cf:projectCompliantBackfillSection">
                        <p class="list">
                            <xsl:text>от </xsl:text>
                            <xsl:if test="cf:startPoint/cf:kilometer">
                                <xsl:text> км </xsl:text>
                                <span class="data"><xsl:value-of select="cf:startPoint/cf:kilometer"/></span>
                            </xsl:if>
                            <xsl:text> ПК </xsl:text>
                            <span class="data">
                                <xsl:value-of select="cf:startPoint/cf:stationNumber"/>
                                <xsl:if test="cf:startPoint/cf:plusPoint">
                                    <xsl:text>+</xsl:text>
                                    <xsl:value-of select="cf:startPoint/cf:plusPoint"/>
                                </xsl:if>
                            </span>
                            <xsl:text> до </xsl:text>
                            <xsl:if test="cf:endPoint/cf:kilometer">
                                <xsl:text> км </xsl:text>
                                <span class="data"><xsl:value-of select="cf:endPoint/cf:kilometer"/></span>
                            </xsl:if>
                            <xsl:text> ПК </xsl:text>
                            <span class="data">
                                <xsl:value-of select="cf:endPoint/cf:stationNumber"/>
                                <xsl:if test="cf:endPoint/cf:plusPoint">
                                    <xsl:text>+</xsl:text>
                                    <xsl:value-of select="cf:endPoint/cf:plusPoint"/>
                                </xsl:if>
                            </span>
                        </p>
                    </xsl:for-each>
                    <p class="list">произведена засыпка <span class="data"><xsl:value-of select="cf:pipelineType" /></span> в соответствии с требованиями проекта и рабочих чертежей.</p>
                    <br/>
                    <p class="list">На участках общей протяженностью
                        <span class="data"><xsl:value-of select="cf:totalPipelineLength/ct:value" /><xsl:text> </xsl:text><xsl:value-of select="cf:totalPipelineLength/ct:unit" /></span>
                    </p>
                    <xsl:for-each select="cf:requirementCompliantBackfillSectionList/cf:requirementCompliantBackfillSection">
                        <p class="list">
                            <xsl:text>от </xsl:text>
                            <xsl:if test="cf:startPoint/cf:kilometer">
                                <xsl:text> км </xsl:text>
                                <span class="data"><xsl:value-of select="cf:startPoint/cf:kilometer"/></span>
                            </xsl:if>
                            <xsl:text> ПК </xsl:text>
                            <span class="data">
                                <xsl:value-of select="cf:startPoint/cf:stationNumber"/>
                                <xsl:if test="cf:startPoint/cf:plusPoint">
                                    <xsl:text>+</xsl:text>
                                    <xsl:value-of select="cf:startPoint/cf:plusPoint"/>
                                </xsl:if>
                            </span>
                            <xsl:text> до </xsl:text>
                            <xsl:if test="cf:endPoint/cf:kilometer">
                                <xsl:text> км </xsl:text>
                                <span class="data"><xsl:value-of select="cf:endPoint/cf:kilometer"/></span>
                            </xsl:if>
                            <xsl:text> ПК </xsl:text>
                            <span class="data">
                                <xsl:value-of select="cf:endPoint/cf:stationNumber"/>
                                <xsl:if test="cf:endPoint/cf:plusPoint">
                                    <xsl:text>+</xsl:text>
                                    <xsl:value-of select="cf:endPoint/cf:plusPoint"/>
                                </xsl:if>
                            </span>
                        </p>
                    </xsl:for-each>
                    <p class="list">засыпка произведена грунтом с гранулометрическими размерами, не превышающими требований СниП 
                        <span class="data">
                            <xsl:for-each select="cf:soilSizeRequirement/descendant-or-self::*">
                                <xsl:for-each select="ct:regulationDocumentsList/ct:regulationDocument">
                                    <xsl:call-template name="docDetailsShortTempl">
                                        <xsl:with-param name="Doc" select="." />
                                    </xsl:call-template>
                                    <xsl:text>, </xsl:text>
                                </xsl:for-each>
                                <xsl:for-each select="ct:projectDocumentationSectionList/ct:projectDocumentationSection">
                                    <xsl:call-template name="docDetailsShortTempl">
                                        <xsl:with-param name="Doc" select="." />
                                    </xsl:call-template>
                                    <xsl:if test="position() != last()">
                                        <xsl:text>, </xsl:text>
                                    </xsl:if>
                                </xsl:for-each>
                                <xsl:for-each select="ct:workDocumentationSectionList">
                                    <xsl:if test="../ct:projectDocumentationSectionList">
                                        <xsl:text>, </xsl:text>
                                    </xsl:if>
                                    <xsl:for-each select="ct:workDocumentationSection">
                                        <xsl:call-template name="docDetailsShortTempl">
                                            <xsl:with-param name="Doc" select="." />
                                        </xsl:call-template>
                                        <xsl:if test="position() != last()">
                                            <xsl:text>, </xsl:text>
                                        </xsl:if>
                                    </xsl:for-each> 
                                </xsl:for-each>                                
                            </xsl:for-each>
                        </span>
                    </p>
                    <br/>
                    <p class="list">На участках общей протяженностью
                        <span class="data"><xsl:value-of select="cf:totalPipelineLength/ct:value" /><xsl:text> </xsl:text><xsl:value-of select="cf:totalPipelineLength/ct:unit" /></span>
                    </p>
                    <xsl:for-each select="cf:crushedSoilSectionList/cf:crushedSoilSection">
                        <p class="list">
                            <xsl:text>от </xsl:text>
                            <xsl:if test="cf:startPoint/cf:kilometer">
                                <xsl:text> км </xsl:text>
                                <span class="data"><xsl:value-of select="cf:startPoint/cf:kilometer"/></span>
                            </xsl:if>
                            <xsl:text> ПК </xsl:text>
                            <span class="data">
                                <xsl:value-of select="cf:startPoint/cf:stationNumber"/>
                                <xsl:if test="cf:startPoint/cf:plusPoint">
                                    <xsl:text>+</xsl:text>
                                    <xsl:value-of select="cf:startPoint/cf:plusPoint"/>
                                </xsl:if>
                            </span>
                            <xsl:text> до </xsl:text>
                            <xsl:if test="cf:endPoint/cf:kilometer">
                                <xsl:text> км </xsl:text>
                                <span class="data"><xsl:value-of select="cf:endPoint/cf:kilometer"/></span>
                            </xsl:if>
                            <xsl:text> ПК </xsl:text>
                            <span class="data">
                                <xsl:value-of select="cf:endPoint/cf:stationNumber"/>
                                <xsl:if test="cf:endPoint/cf:plusPoint">
                                    <xsl:text>+</xsl:text>
                                    <xsl:value-of select="cf:endPoint/cf:plusPoint"/>
                                </xsl:if>
                            </span>
                        </p>
                    </xsl:for-each>
                    <p class="list">выполнена присыпка уложенного <span class="data"><xsl:value-of select="cf:pipelineType" /></span> для защиты от повреждений измельченным грунтом толщиной слоя <span class="data"><xsl:value-of select="cf:crushedSoilLayerThickness/ct:value" /><xsl:text> </xsl:text><xsl:value-of select="cf:crushedSoilLayerThickness/ct:unit" /></span>, после чего выполнена засыпка грунтом с фракциями, превышающими требования строительных норм и правил.</p>
                    <br/>
                    <p class="list">На основании изложенного засыпка <span class="data"><xsl:value-of select="cf:pipelineType" /></span> на указанных участках считается принятой.                    </p>
                    <br/>
                    <xsl:if test="../cf:representativeDeveloperControlSignature or ../cf:representativeTechnicalCustomerControlSignature or ../cf:representativeBuildingOperatorControlSignature or ../cf:representativeRegionalBuildingOperatorControlSignature">
                        <div style="display: flex; justify-content: space-between; align-items:baseline ; width: 100%; gap:3em">
                            <div style="flex: 3;">
                                <p class="list">Представитель заказчика </p>
                            </div>
                            <xsl:choose>
                                <xsl:when test="../cf:representativeDeveloperControlSignature">
                                    <xsl:for-each select="cf:representativeDeveloperControl">
                                        <xsl:call-template name="signature"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="../cf:representativeTechnicalCustomerControlSignature">
                                    <xsl:for-each select="cf:representativeTechnicalCustomerControl">
                                        <xsl:call-template name="signature"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="../cf:representativeBuildingOperatorControlSignature">
                                    <xsl:for-each select="cf:representativeBuildingOperatorControl">
                                        <xsl:call-template name="signature"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="../cf:representativeRegionalBuildingOperatorControlSignature">
                                    <xsl:for-each select="cf:representativeRegionalBuildingOperatorControl">
                                        <xsl:call-template name="signature"/>
                                    </xsl:for-each>
                                </xsl:when>
                            </xsl:choose>
                        </div>
                    </xsl:if>
                    <xsl:if test="../cf:representativeBuildingContractorSignature or ../cf:representativeWorkExecutorSignature">
                        <div style="display: flex; justify-content: space-between; align-items:baseline ; width: 100%; gap:3em">
                            <div style="flex: 3;">
                                <p class="list">Производитель работ </p>
                            </div>
                            <xsl:choose>
                                <xsl:when test="../cf:representativeWorkExecutorSignature">
                                    <xsl:for-each select="cf:representativeWorkExecutor">
                                        <xsl:call-template name="signature"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="not(../cf:representativeWorkExecutorSignature)">
                                    <xsl:for-each select="cf:representativeBuildingContractor">
                                        <xsl:call-template name="signature"/>
                                    </xsl:for-each>
                                </xsl:when>
                            </xsl:choose>
                        </div>
                    </xsl:if>
                </xsl:for-each>
            </body>
        </html>
    </xsl:template>

    <!-- Вывод даты в формате ДД.ММ.ГГГГ-->
    <xsl:template name="formatdate">
        <xsl:param name="DateStr" />
        
        <xsl:if test="$DateStr != ''">
            <xsl:variable name="dd">
                <xsl:value-of select="substring($DateStr, 9, 2)" />
            </xsl:variable>
            
            <xsl:variable name="mm">
                <xsl:value-of select="substring($DateStr, 6, 2)" />
            </xsl:variable>
            
            <xsl:variable name="yyyy">
                <xsl:value-of select="substring($DateStr, 1, 4)" />
            </xsl:variable>
            
            <xsl:choose>
                <xsl:when test="$mm = 01">
                    <xsl:value-of select="concat('«', $dd, '» ', 'января ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 02">
                    <xsl:value-of select="concat('«', $dd, '» ', 'февраля ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 03">
                    <xsl:value-of select="concat('«', $dd, '» ', 'марта ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 04">
                    <xsl:value-of select="concat('«', $dd, '» ', 'апреля ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 05">
                    <xsl:value-of select="concat('«', $dd, '» ', 'мая ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 06">
                    <xsl:value-of select="concat('«', $dd, '» ', 'июня ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 07">
                    <xsl:value-of select="concat('«', $dd, '» ', 'июля ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 08">
                    <xsl:value-of select="concat('«', $dd, '» ', 'августа ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 09">
                    <xsl:value-of select="concat('«', $dd, '» ', 'сентября ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 10">
                    <xsl:value-of select="concat('«', $dd, '» ', 'октября ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 11">
                    <xsl:value-of select="concat('«', $dd, '» ', 'ноября ', $yyyy, ' г.' )" />
                </xsl:when>
                <xsl:when test="$mm = 12">
                    <xsl:value-of select="concat('«', $dd, '» ', 'декабря ', $yyyy, ' г.' )" />
                </xsl:when>
            </xsl:choose>
            
        </xsl:if>
    </xsl:template>
    
    <!--Реквизиты документов: name № number от «ДД.» ММ.ГГГГ г.-->
    <xsl:template name="docDetailsTempl">
        <xsl:param name="Doc"/>
        <xsl:value-of select="$Doc/ct:name"/> №
        <xsl:choose>
            <xsl:when test="ct:structureElementNumber">
                <xsl:for-each select="ct:structureElementNumber">
                    <xsl:value-of select="."/>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$Doc/ct:number"/> 
            </xsl:otherwise>
        </xsl:choose>
        от 
        <xsl:call-template name="formatdate">
            <xsl:with-param name="DateStr" select="$Doc/ct:date" />
        </xsl:call-template>
    </xsl:template>
    
    <!--Реквизиты документов: name № number-->
    <xsl:template name="docDetailsShortTempl">
        <xsl:param name="Doc"/>
        <xsl:value-of select="$Doc/ct:name"/> №
        <xsl:value-of select="$Doc/ct:number"/>
    </xsl:template>
    
    <xsl:template name="locationTempl">
        <xsl:param name="location"/>
        <xsl:for-each select="$location/descendant-or-self::*">
            <xsl:if test="ct:axes">
                <xsl:value-of select="concat('Ось: ', ct:axes)"/>
            </xsl:if>
            <xsl:if test="ct:ranks">
                <xsl:value-of select="concat('Ряд: ', ct:ranks)"/>
            </xsl:if>
            <xsl:if test="ct:marks">
                <xsl:value-of select="concat('Отметка: ', ct:marks)"/>
            </xsl:if>
            <xsl:if test="ct:floors">
                <xsl:value-of select="concat('Этаж: ', ct:floors)"/>
            </xsl:if>
            <xsl:if test="ct:tiers">
                <xsl:value-of select="concat('Ярус: ', ct:tiers)"/>
            </xsl:if>
            <xsl:if test="ct:sections">
                <xsl:value-of select="concat('Секция: ', ct:sections)"/>
            </xsl:if>
            <xsl:if test="ct:premises">
                <xsl:value-of select="concat('Помещение: ', ct:premises)"/>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="initials">
        <xsl:param name="NameStr" />
        
        <xsl:if test="$NameStr !=''">
            <xsl:variable name="i">
                <xsl:value-of select="substring($NameStr, 1, 1)" />
            </xsl:variable>
            
            <xsl:value-of select="concat($i, '.')" />
        </xsl:if>
    </xsl:template>
       
    <xsl:template match="ct:passportDetails">
        <xsl:choose>
            <xsl:when test="ct:documentDetailsForeignCitizen">
                <xsl:for-each select="ct:documentDetailsForeignCitizen">
                    <xsl:value-of select="ct:docName"/><xsl:text> </xsl:text>
                    <xsl:if test="ct:series">
                        Серия:
                        <xsl:value-of select="ct:series"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    №<xsl:value-of select="ct:number"/> дата выдачи:
                    <xsl:call-template name="formatdate">
                        <xsl:with-param name="DateStr" select="ct:dateIssue" />
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ct:passportDetailsRussianFederation">
                <xsl:for-each select="ct:passportDetailsRussianFederation">
                    серия:<xsl:value-of select="ct:series"/>
                    №<xsl:value-of select="ct:number"/> дата выдачи:
                    <xsl:call-template name="formatdate">
                        <xsl:with-param name="DateStr" select="ct:dateIssue" />
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
           
    <xsl:template name="orgTempl">
        <xsl:param name="Org"/>
        <xsl:choose>
            <xsl:when test="ct:organization">
                <xsl:for-each select="ct:organization">
                    <xsl:choose>
                        <xsl:when test="ct:legalEntity">
                            <xsl:for-each select="ct:legalEntity">
                                <xsl:value-of select="ct:name"/>
                                <xsl:text>, ОГРН: </xsl:text><xsl:value-of select="ct:ogrn"/>
                                <xsl:text>, ИНН: </xsl:text><xsl:value-of select="ct:inn"/>
                            </xsl:for-each>                               
                        </xsl:when>
                        <xsl:when test="ct:individualEntrepreneur">
                            <xsl:for-each select="ct:individualEntrepreneur">
                                <xsl:value-of select="ct:lastName"/><xsl:text> </xsl:text>
                                <xsl:value-of select="ct:firstName"/>
                                <xsl:if test="ct:middleName">
                                    <xsl:text> </xsl:text>
                                    <xsl:value-of select="ct:middleName"/>
                                </xsl:if>
                                <xsl:text>, ОГРНИП: </xsl:text><xsl:value-of select="ct:ogrnip"/>
                                <xsl:text>, ИНН: </xsl:text><xsl:value-of select="ct:inn"/>                                                             
                            </xsl:for-each>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ct:organizationInfo">
                <xsl:for-each select="ct:organizationInfo">
                    <xsl:choose>
                        <xsl:when test="ct:legalEntity">
                            <xsl:for-each select="ct:legalEntity">
                                <xsl:value-of select="ct:name"/>
                                <xsl:text>, ОГРН: </xsl:text><xsl:value-of select="ct:ogrn"/>
                                <xsl:text>, ИНН: </xsl:text><xsl:value-of select="ct:inn"/>
                            </xsl:for-each> 
                        </xsl:when>
                        <xsl:when test="ct:individualEntrepreneur">
                            <xsl:for-each select="ct:individualEntrepreneur">
                                <xsl:value-of select="ct:lastName"/><xsl:text> </xsl:text>
                                <xsl:value-of select="ct:firstName"/>
                                <xsl:if test="ct:middleName">
                                    <xsl:text> </xsl:text>
                                    <xsl:value-of select="ct:middleName"/>
                                </xsl:if>
                                <xsl:text>, ОГРНИП: </xsl:text><xsl:value-of select="ct:ogrnip"/>
                                <xsl:text>, ИНН: </xsl:text><xsl:value-of select="ct:inn"/>
                            </xsl:for-each>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ct:individual">
                <xsl:for-each select="ct:individual">
                    <xsl:value-of select="ct:lastName"/><xsl:text> </xsl:text>
                    <xsl:value-of select="ct:firstName"/>
                    <xsl:if test="ct:middleName">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="ct:middleName"/>
                    </xsl:if>
                    <xsl:text>, адрес: </xsl:text>
                    <xsl:for-each select="ct:address">
                        <xsl:call-template name="postalAddress"/>
                    </xsl:for-each>
                </xsl:for-each>      
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="representative">
        <p class="data">
            <xsl:value-of select="ct:position"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="ct:lastName"/><xsl:text> </xsl:text>
            <xsl:value-of select="ct:firstName"/>
            <xsl:if test="ct:middleName">
                <xsl:text> </xsl:text>
                <xsl:value-of select="ct:middleName"/>
            </xsl:if>
        </p>
    </xsl:template>
    
    <xsl:template name="OrgName">
        <xsl:choose>
            <xsl:when test="ct:organizationInfo/ct:legalEntity">
                <xsl:for-each select="ct:organizationInfo/ct:legalEntity">
                    <xsl:value-of select="ct:name"/><xsl:text> </xsl:text>
                </xsl:for-each>  
            </xsl:when>
            <xsl:when test="ct:organizationInfo/ct:individualEntrepreneur">
                <xsl:for-each select="ct:organizationInfo/ct:individualEntrepreneur">
                    <xsl:value-of select="ct:lastName"/><xsl:text> </xsl:text>
                    <xsl:value-of select="ct:firstName"/>
                    <xsl:if test="ct:middleName">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="ct:middleName"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
      
    <!-- Фамилия И.О. -->
    <xsl:template name="nameTempl">
        <xsl:param name="Person"/>
        <xsl:value-of select="$Person/ct:lastName"/><xsl:text> </xsl:text>
        <xsl:call-template name="initials">
            <xsl:with-param name="NameStr" select="$Person/ct:firstName" />
        </xsl:call-template>
        <xsl:if test="$Person/ct:middleName">
            <xsl:call-template name="initials">
                <xsl:with-param name="NameStr" select="$Person/ct:middleName" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="signature">
        <div style="flex: 2; color:#8995ce; border: 1px solid; padding: 5px; padding-bottom: 0px;">
            <p class="list" style="text-align: center; font-size: clamp(10px, 1.5vw, 16px);"><b>Документ подписан электронной подписью</b></p>
        </div>
        <div style="flex: 2;">
            <p class="data">
                <xsl:call-template name="nameTempl">
                    <xsl:with-param name="Person" select="." />
                </xsl:call-template>
            </p>
            <p class="under" >(фамилия, инициалы)</p>
        </div>
    </xsl:template>
    
    <xsl:template name="postalAddress">
        <xsl:choose>
            <xsl:when test="ct:stringAddress">
                <xsl:value-of select="ct:stringAddress"/>
            </xsl:when>
            <xsl:when test="ct:detalizedAddress">
                <xsl:for-each select="ct:detalizedAddress">
                    <xsl:value-of select="ct:country"/><xsl:text> </xsl:text>
                    <xsl:value-of select="ct:entityOfFederation"/><xsl:text> </xsl:text>
                    <xsl:value-of select="ct:districtOrRegionCode"/>
                    <xsl:if test="ct:settlement">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="ct:settlement"/>
                    </xsl:if>
                    <xsl:if test="ct:locality">
                        <xsl:text> </xsl:text>
                        <xsl:for-each select="ct:locality">
                            <xsl:value-of select="ct:localityType"/><xsl:text> </xsl:text>
                            <xsl:value-of select="ct:localityName"/>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:if test="ct:planningStructure">
                        <xsl:text> </xsl:text>
                        <xsl:for-each select="ct:planningStructure">
                            <xsl:value-of select="ct:planningStructureElement"/><xsl:text> </xsl:text>
                            <xsl:value-of select="ct:planningStructureObject"/>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:if test="ct:roadNetwork">
                        <xsl:text> </xsl:text>
                        <xsl:for-each select="ct:roadNetwork">
                            <xsl:value-of select="ct:roadNetworkElement"/><xsl:text> </xsl:text>
                            <xsl:value-of select="ct:roadNetworkObject"/>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:if test="ct:addressingObjectType">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="ct:addressingObjectType"/>
                    </xsl:if>
                    <xsl:if test="ct:plotNumber">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="ct:plotNumber"/>
                    </xsl:if>
                    <xsl:if test="ct:building">
                        <xsl:text> </xsl:text>
                        <xsl:for-each select="ct:building">
                            <xsl:value-of select="ct:buildingType"/><xsl:text> </xsl:text>
                            <xsl:value-of select="ct:buildingNumber"/>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:if test="ct:room">
                        <xsl:text> </xsl:text>
                        <xsl:for-each select="ct:room">
                            <xsl:value-of select="ct:roomType"/><xsl:text> </xsl:text>
                            <xsl:value-of select="ct:roomNumber"/>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:if test="ct:parkingSpaceNumber">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="ct:parkingSpaceNumber"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ct:stringAddressFIAS">
                <xsl:for-each select="ct:stringAddressFIAS">
                    <xsl:value-of select="ct:stringAddress"/>
                </xsl:for-each>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="constructionSiteAddress">
        <xsl:value-of select="ct:country"/><xsl:text> </xsl:text>
        <xsl:for-each select="ct:entitysOfFederationList/ct:entitysOfFederationListItem">
            <xsl:value-of select="."/><xsl:text> </xsl:text>
        </xsl:for-each>
        <xsl:for-each select="ct:districtOrRegionCodeList/ct:districtOrRegionCodeListItem">
            <xsl:value-of select="."/><xsl:text> </xsl:text>
        </xsl:for-each>
        <xsl:if test="ct:settlement">
            <xsl:text> </xsl:text>
            <xsl:value-of select="ct:settlement"/>
        </xsl:if>
        <xsl:if test="ct:locality">
            <xsl:text> </xsl:text>
            <xsl:for-each select="ct:locality">
                <xsl:value-of select="ct:localityType"/><xsl:text> </xsl:text>
                <xsl:value-of select="ct:localityName"/>
            </xsl:for-each>
        </xsl:if>
        <xsl:if test="ct:planningStructure">
            <xsl:text> </xsl:text>
            <xsl:for-each select="ct:planningStructure">
                <xsl:value-of select="ct:planningStructureElement"/><xsl:text> </xsl:text>
                <xsl:value-of select="ct:planningStructureObject"/>
            </xsl:for-each>
        </xsl:if>
        <xsl:if test="ct:roadNetwork">
            <xsl:text> </xsl:text>
            <xsl:for-each select="ct:roadNetwork">
                <xsl:value-of select="ct:roadNetworkElement"/><xsl:text> </xsl:text>
                <xsl:value-of select="ct:roadNetworkObject"/>
            </xsl:for-each>
        </xsl:if>
        <xsl:if test="ct:addressingObjectType">
            <xsl:text> </xsl:text>
            <xsl:value-of select="ct:addressingObjectType"/>
        </xsl:if>
        <xsl:if test="ct:plotNumber">
            <xsl:text> </xsl:text>
            <xsl:value-of select="ct:plotNumber"/>
        </xsl:if>
        <xsl:if test="ct:building">
            <xsl:text> </xsl:text>
            <xsl:for-each select="ct:building">
                <xsl:value-of select="ct:buildingType"/><xsl:text> </xsl:text>
                <xsl:value-of select="ct:buildingNumber"/>
            </xsl:for-each>
        </xsl:if>
        <xsl:if test="ct:room">
            <xsl:text> </xsl:text>
            <xsl:for-each select="ct:room">
                <xsl:value-of select="ct:roomType"/><xsl:text> </xsl:text>
                <xsl:value-of select="ct:roomNumber"/>
            </xsl:for-each>
        </xsl:if>
        <xsl:if test="ct:parkingSpaceNumber">
            <xsl:text> </xsl:text>
            <xsl:value-of select="ct:parkingSpaceNumber"/>
        </xsl:if>
        <xsl:if test="ct:arbitraryAddress">
            <xsl:text> </xsl:text>
            <xsl:value-of select="ct:arbitraryAddress"/>
        </xsl:if>
    </xsl:template>
   
</xsl:stylesheet>