// @ts-nocheck

// import 'phaser';
// import UIPlugin from 'phaser3-rex-plugins/templates/ui/ui-plugin';
import { COLOR_LIGHT, COLOR_PRIMARY, COLOR_DARK } from './Const';
import { DefaultDepth, DragObjectDepth } from './Const';
import CreateColumnPanelsBox from './CreateColumnPanelsBox';
import CreateHeader from './CreateHeader';
import AddResizeController from './AddResizeController';

type Scene = {
  rexUI: {
    add: {
      sizer: (config: SizerConfig) => Sizer;
    };
  };
};

type SizerConfig = {
  orientation: string;
  space: {
    left: number;
    right: number;
    top: number;
    bottom: number;
  };
};

type Sizer = {
  add: (item: any, config: any) => void;
};

const CreateScrollablePanel = (
  scene: Scene,
  itemCountArray: any[],
): ScrollablePanel => {
  const config: ScrollablePanelConfig = {
    width: 400,
    height: 400,
    background: scene.rexUI.add.roundRectangle({
      radius: 10,
      strokeColor: COLOR_DARK,
    }),
    panel: {
      child: CreateColumnPanelsBox(scene, itemCountArray),
      mask: {
        padding: 2,
        updateMode: 'everyTick',
      },
    },
    sliderX: {
      track: { width: 20, radius: 10, color: COLOR_DARK },
      thumb: { radius: 13, color: COLOR_LIGHT },
    },
    sliderY: {
      track: { width: 20, radius: 10, color: COLOR_DARK },
      thumb: { radius: 13, color: COLOR_LIGHT },
    },
    scrollerX: false,
    scrollerY: false,
    space: {
      left: 10,
      right: 10,
      top: 10,
      bottom: 10,
      sliderX: 10,
      sliderY: 10,
    },
    header: CreateHeader(scene),
  };

  // Создаем ScrollablePanel
  const scrollablePanel = scene.rexUI.add.scrollablePanel(config);

  // Устанавливаем возможность перетаскивания
  scrollablePanel.setDraggable('header');

  // Вызываем метод layout для обновления компоновки
  scrollablePanel.layout();

  // Добавляем контроллер для изменения размера
  AddResizeController(scrollablePanel);

  return scrollablePanel;
};

export default CreateScrollablePanel;
