// @ts-nocheck

import { COLOR_LIGHT, COLOR_PRIMARY, COLOR_DARK } from './Const';
import CreateItem from './CreateItem';
import AddDragDropItemBehavior from './AddDragDropItemBehavior';

type SceneType = {
  rexUI: {
    add: {
      sizer: (config: SizerConfig) => Sizer;
      roundRectangle: (config: any) => any;
    };
  };
};

type SizerConfig = {
  orientation: string;
  space: {
    left: number;
    right: number;
    top: number;
    bottom: number;
    item?: number;
  };
};

type Sizer = {
  add: (item: any, config: any) => void;
  addBackground: (item: any, key: string) => void;
};

const CreateItemsBox = (scene: SceneType, itemCount: number): Sizer => {
  const itemsBox: Sizer = scene.rexUI.add.sizer({
    orientation: 'y',
    space: {
      left: 5,
      right: 5,
      top: 5,
      bottom: 5,
      item: 5,
    },
  });

  itemsBox.addBackground(scene.rexUI.add.roundRectangle({}), 'background');

  for (let i = 0; i < itemCount; i++) {
    itemsBox.add(CreateItem(scene, i.toString()), {
      proportion: 0,
      expand: true,
    });
  }

  AddDragDropItemBehavior(itemsBox);

  return itemsBox;
};

export default CreateItemsBox;
