// @ts-nocheck

import { COLOR_LIGHT, COLOR_PRIMARY, COLOR_DARK } from './Const';
import CreateDropDownList from './CreateDropDownList';

const CreateHeader = function (
  scene: Phaser.Scene
): Phaser.GameObjects.Container {
  const sizer = scene.rexUI.add
    .sizer({
      orientation: 'x',
    })
    .addBackground(scene.rexUI.add.roundRectangle(0, 0, 20, 20, 0, COLOR_DARK));

  const headerLabel = scene.rexUI.add.label({
    text: scene.add.text(0, 0, 'Header'),
  });

  const dropDownButton = CreateDropDownList(scene);

  sizer
    .add(headerLabel, { proportion: 1, expand: true })
    .add(dropDownButton, { proportion: 0, expand: true });

  return sizer;
};
export default CreateHeader;
