// @ts-nocheck

import { COLOR_LIGHT, COLOR_PRIMARY, COLOR_DARK } from './Const';
import GetMaxTextObjectSize from './GetMaxTextObjectSize';
import CreateTextObject from './CreateTextObject';
import CreatePopupList from './CreatePopupList';

const CreateDropDownList = function (
  scene: Phaser.Scene
): Phaser.GameObjects.Text {
  const options = ['Добавить колонку', 'Переименовать доску'];
  const maxTextSize = GetMaxTextObjectSize(scene, options);
  const label = scene.rexUI.add
    .label({
      background: scene.rexUI.add
        .roundRectangle(0, 0, 2, 2, 0, COLOR_PRIMARY)
        .setAlpha(0),
      text: CreateTextObject(scene, '...').setFixedSize(
        maxTextSize.width,
        maxTextSize.height
      ),
      space: {
        left: 10,
        right: 10,
        top: 10,
        bottom: 10,
        icon: 10,
      },
    })
    .setData('value', '');

  let menu: Phaser.GameObjects.Container | undefined;

  scene.rexUI.add.click(label).on('click', () => {
    if (!menu || !menu.scene) {
      const menuX = label.getElement('text').getTopLeft().x;
      const menuY = label.bottom;
      menu = CreatePopupList(scene, menuX, menuY, options, function (button) {
        console.log('Click', button.text); // Добавленный console.log
        if (button.text === 'Добавить колонку') {
          // Ваш код для добавления новой колонки
        } else if (button.text === 'Переименовать доску') {
          // Ваш код для переименования доски
        }
        menu?.collapse();
        menu = undefined;
      });
    } else {
      menu.collapse();
      menu = undefined;
    }
  });

  return label;
};
export default CreateDropDownList;
