import { RouteRecordRaw } from 'vue-router';
import { useCurrentUserStore } from 'src/stores/current-user';

const routes: RouteRecordRaw[] = [
  {
    path: '/',
    name: 'start',
    meta: { title: 'Start' },
    component: () => import('layouts/IndexLayout.vue'),
    beforeEnter: (to, from) => {
      const store = useCurrentUserStore();
      if (store.getUserId) {
        return { name: 'projects' };
      }
      return;
    },
  },
  {
    path: '/projects',
    component: () => import('layouts/MainLayout.vue'),
    children: [
      {
        path: '/projects/:uuid/',
        name: 'project',
        meta: { title: 'Project' },
        component: () => import('pages/CurrentProjectPage.vue'),
        beforeEnter: (to, from) => {
          const store = useCurrentUserStore();
          if (!store.getUserId) {
            return { name: 'start' };
          }
          return;
        },
      },
      {
        path: '',
        name: 'projects',
        meta: { title: 'Projects' },
        component: () => import('pages/ProjectsPage.vue'),
        beforeEnter: (to, from) => {
          const store = useCurrentUserStore();
          if (!store.getUserId) {
            return { name: 'start' };
          }
          return;
        },
      },
      {
        path: '/login',
        name: 'login',
        meta: { title: 'Login' },
        component: () => import('pages/LoginPage.vue'),
        beforeEnter: (to, from) => {
          const store = useCurrentUserStore();
          if (store.getUserId) {
            return { name: 'projects' };
          }
          return;
        },
      },
      {
        path: '/registration',
        name: 'registration',
        meta: { title: 'registration' },
        component: () => import('pages/RegistrationPage.vue'),
        beforeEnter: (to, from) => {
          const store = useCurrentUserStore();
          if (store.getUserId) {
            return { name: 'projects' };
          }
          return;
        },
      },
      {
        path: '/profile',
        name: 'profile',
        meta: { title: 'Profile' },
        component: () => import('pages/ProfilePage.vue'),
        beforeEnter: (to, from) => {
          const store = useCurrentUserStore();
          if (!store.getUserId) {
            return { name: 'start' };
          }
          return;
        },
      },
      {
        path: '/endless',
        name: 'endless',
        meta: { title: 'Endless' },
        component: () => import('pages/EndlessPage.vue'),
        beforeEnter: (to, from) => {
          const store = useCurrentUserStore();
          // if (!store.getUserId) {
          //   return { name: 'start' };
          // }
          return;
        },
      },
      {
        path: '/endless2',
        name: 'endless2',
        meta: { title: 'Endless' },
        component: () => import('pages/EndlessPage2.vue'),
        beforeEnter: (to, from) => {
          const store = useCurrentUserStore();
          // if (!store.getUserId) {
          //   return { name: 'start' };
          // }
          return;
        },
      },
      {
        path: '/endless3',
        name: 'endless3',
        meta: { title: 'Endless' },
        component: () => import('pages/canvas/ActualCanvas.vue'),
        beforeEnter: (to, from) => {
          const store = useCurrentUserStore();
          // if (!store.getUserId) {
          //   return { name: 'start' };
          // }
          return;
        },
      },
      {
        path: '/privacypolicy',
        name: 'privacypolicy',
        component: () => import('pages/PrivacyPolicyPage.vue'),
      },
    ],
  },

  // Always leave this as last one,
  // but you can also remove it
  {
    path: '/:catchAll(.*)*',
    component: () => import('pages/ErrorNotFound.vue'),
  },
];

export default routes;
