// @ts-nocheck

import {
  COLOR_LIGHT,
  COLOR_PRIMARY,
  COLOR_DARK,
  DefaultDepth,
  DragObjectDepth,
} from './Const';

type SceneType = {
  rexUI: {
    add: {
      label: (config: LabelConfig) => Label;
      roundRectangle: (config: RoundRectangleConfig) => RoundRectangle;
    };
  };
  add: {
    text: (x: number, y: number, text: string, style: TextStyle) => Text;
  };
};

type LabelConfig = {
  background: RoundRectangle;
  text: Text;
  align: string;
  space: {
    left: number;
    right: number;
    top: number;
    bottom: number;
  };
};

type RoundRectangleConfig = {
  radius: number;
  color: string;
};

type TextStyle = {
  fontSize: number;
};

type RoundRectangle = {
  setStrokeStyle: (width?: number, color?: number) => void;
};

type Text = {
  fontSize: number;
};

type Label = {
  setDraggable: (config: DraggableConfig) => Label;
  on: (event: string, callback: (this: Label) => void) => Label;
  setDepth: (depth: number) => void;
  getElement: (element: string) => RoundRectangle | Text;
};

type DraggableConfig = {
  sensor: Label;
  target: Label;
};

const CreateItem = (scene: SceneType, text: string): Label => {
  const item: Label = scene.rexUI.add.label({
    background: scene.rexUI.add.roundRectangle({
      radius: 10,
      color: COLOR_PRIMARY,
    }),
    text: scene.add.text(0, 0, text, {
      fontSize: 18,
    }),
    align: 'center',
    space: {
      left: 5,
      right: 5,
      top: 5,
      bottom: 5,
    },
  });

  SetDraggable(item);

  return item;
};

const SetDraggable = (item: Label): void => {
  item
    .setDraggable({
      sensor: item,
      target: item,
    })
    .on('sizer.dragstart', () => OnItemDragStart.call(item))
    .on('sizer.dragend', () => OnItemDragEnd.call(item));
};

const OnItemDragStart = function (this: Label): void {
  this.setDepth(DragObjectDepth);
  this.getElement('background').setStrokeStyle(3, 0xff0000);
};

const OnItemDragEnd = function (this: Label): void {
  this.setDepth(DefaultDepth);
  this.getElement('background').setStrokeStyle();
};

export default CreateItem;
