// @ts-nocheck

import { COLOR_LIGHT, COLOR_PRIMARY, COLOR_DARK } from './Const';
import { DefaultDepth, DragObjectDepth } from './Const';
import CreateItemsBox from './CreateItemsBox';

type DialogFunction = (config: any) => any;
type RoundRectangleFunction = (config: any) => any;
type LabelFunction = (config: any) => any;
type TextFunction = (x: number, y: number, text: string, style: any) => any;

type SceneType = {
  rexUI: {
    add: {
      dialog: DialogFunction;
      roundRectangle: RoundRectangleFunction;
      label: LabelFunction;
    };
  };
  add: {
    text: TextFunction;
  };
};

const CreateColumnPanel = (
  scene: SceneType,
  title: string,
  itemCount: number
) => {
  const panel = scene.rexUI.add
    .dialog({
      width: 120,
      space: { left: 10, right: 10, top: 10, bottom: 10 },
      background: scene.rexUI.add.roundRectangle({
        strokeColor: COLOR_DARK,
      }),
      title: CreateTitle(scene, title),
      content: CreateItemsBox(scene, itemCount),
      proportion: {
        content: 1,
      },
    })
    .setOrigin(0, 0);

  SetDraggable(panel);

  return panel;
};

const CreateTitle = (scene: SceneType, text: string) => {
  return scene.rexUI.add.label({
    background: scene.rexUI.add.roundRectangle({
      color: COLOR_LIGHT,
    }),
    text: scene.add.text(0, 0, text, {
      fontSize: 18,
    }),
    align: 'left',
    space: {
      left: 5,
      right: 5,
      top: 5,
      bottom: 5,
    },
  });
};

const SetDraggable = (panel: any) => {
  panel
    .setDraggable({
      sensor: 'title',
      target: panel,
    })
    .on('sizer.dragstart', OnPanelDragStart, panel)
    .on('sizer.dragend', OnPanelDragEnd, panel);
};

const OnPanelDragStart = function (this: any) {
  this.setDepth(DragObjectDepth);
  this.getElement('background').setStrokeStyle(3, 0xff0000);
};

const OnPanelDragEnd = function (this: any) {
  this.setDepth(DefaultDepth);
  this.getElement('background').setStrokeStyle(2, COLOR_DARK);
};

export default CreateColumnPanel;
