// @ts-nocheck

const AddResizeController = (sizer: Phaser.GameObjects.Container): void => {
  const scene = sizer.scene;

  const bottomRighterController = scene.add.rectangle(
    sizer.right - 15,
    sizer.bottom - 15,
    30,
    30,
    0x333333,
  );

  bottomRighterController
    .setInteractive({ draggable: true })
    .on('drag', function (pointer, dragX, dragY) {
      const topX = sizer.left,
        topY = sizer.top;
      const width = dragX - topX,
        height = dragY - topY;

      sizer.setChildPosition(bottomRighterController, dragX, dragY);

      sizer.setMinSize(width, height).layout();

      sizer.left = topX;
      sizer.top = topY;
    });

  sizer.pin(bottomRighterController);
};
export default AddResizeController;
