// @ts-nocheck

import { COLOR_LIGHT, COLOR_PRIMARY, COLOR_DARK } from './Const';
import CreateModalLabel from './CreateModalLabel';

const CreateRequestModalColumn = (scene: Phaser.Scene): any => {
  const content = '1';

  const textArea = scene.rexUI.add
    .textAreaInput({
      x: 400,
      y: 300,
      width: 280,
      height: 20,

      background: scene.rexUI.add.roundRectangle(0, 0, 2, 2, 0, COLOR_PRIMARY),

      text: {
        background: {
          stroke: 'black',
          // 'focus.stroke': 'red',
        },

        style: {
          fontSize: 20,
          backgroundBottomY: 1,
          backgroundHeight: 20,
          'cursor.color': 'black',
          'cursor.backgroundColor': 'white',
          color: '#000000',
        },
      },

      space: {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0,
        text: 10,
        header: 0,
        footer: 0,
      },

      mouseWheelScroller: {
        focus: false,
        speed: 0.1,
      },

      content: content,
    })
    .layout()
    .on('textchange', function (text: string) {
      console.log(`Content: '${text}'`);
    });

  textArea.setDepth(2);

  const separator = scene.add.rectangle(0, 0, 280, 2, 0x000000);

  const dialog = scene.rexUI.add
    .dialog({
      background: scene.rexUI.add
        .roundRectangle(0, 0, 100, 100, 20, 0xffffff)
        .setStrokeStyle(2, 0x000000),

      title: scene.rexUI.add.label({
        text: scene.add.text(0, 0, 'Редактирование объекта', {
          fontSize: '24px',
          color: '#000000',
        }),
        space: {
          left: 15,
          right: 15,
          top: 10,
          bottom: 10,
        },
      }),

      content: textArea,

      actions: [
        CreateModalLabel(scene, 'Отменить'),
        CreateModalLabel(scene, 'Сохранить'),
      ],

      space: {
        title: 25,
        content: 25,
        action: 15,

        left: 20,
        right: 20,
        top: 20,
        bottom: 20,
      },

      align: {
        actions: 'right',
      },

      expand: {
        content: false,
      },
    })
    .on('button.over', function (button, groupName, index, pointer, event) {
      button.getElement('background').setStrokeStyle(1, 0xffffff);
    })
    .on('button.out', function (button, groupName, index, pointer, event) {
      button.getElement('background').setStrokeStyle();
    });

  return dialog;
};
export default CreateRequestModalColumn;
