// @ts-nocheck

import { COLOR_PRIMARY } from './Const'; // Удалил неиспользуемые переменные

type PanelType = {
  x: number;
  y: number;
  layout: () => void;
  on: (event: string, callback: (pointer?: PointerType) => void) => void; // Заменил Function на более конкретный тип
  setData: (data: Record<string, unknown>) => void;
  getData: (key: string) => any; // Можно уточнить тип, если известно, какие данные могут быть получены
  moveFrom: (config: { x: number; y: number; speed: number }) => void;
};

type PointerType = {
  x: number;
  y: number;
};

type PanelsBoxType = {
  getElement: (element: string) => PanelType[];
  remove: (panel: PanelType) => void;
  insertAtPosition: (
    x: number,
    y: number,
    panel: PanelType,
    config: { expand: boolean }
  ) => void;
  getTopmostSizer: () => { layout: () => void };
};

const AddDragDropColumnPanelBehavior = (panelsBox: PanelsBoxType) => {
  const panels = panelsBox.getElement('items');
  for (const panel of panels) {
    panel
      .on('sizer.dragstart', function () {
        panelsBox.remove(panel);
        panel.layout();
      })
      .on('sizer.dragend', function (pointer: PointerType) {
        // Удалил неиспользуемые переменные
        panelsBox.insertAtPosition(pointer.x, pointer.y, panel, {
          expand: true,
        });
        ArrangePanels(panelsBox);
      });
  }
};

const ArrangePanels = (panelsBox: PanelsBoxType) => {
  const panels = panelsBox.getElement('items');

  for (const panel of panels) {
    panel.setData({ startX: panel.x, startY: panel.y });
  }

  panelsBox.getTopmostSizer().layout();

  for (const panel of panels) {
    const fromX = panel.getData('startX') as number;
    const fromY = panel.getData('startY') as number;
    if (panel.x !== fromX || panel.y !== fromY) {
      panel.moveFrom({ x: fromX, y: fromY, speed: 300 });
    }
  }
};

export default AddDragDropColumnPanelBehavior;
