import { defineStore, acceptHMRUpdate } from 'pinia';
import { apollo } from 'src/boot/apollo';
import { debugLog } from 'src/utils';
import { kanvaso } from '../queries/queries.js';
import { kanvasoEdit } from 'src/queries/mutations.js';
export const useKanvasoStore = defineStore('Kanvaso', {
  state: () => ({
    kanvaso: null,

  }),
  getters: {
    getKanvaso: (state) => {
      return state.kanvaso;
    },
    getKanvasoLength: (state) => {
      return state.kanvaso ? state.kanvaso.length : 0;
    },
  },
  actions: {
    async onGetKanvaso(payload) {
      debugLog('on get kanvaso');
      try {
        const response = await apollo.default.query({
          query: kanvaso,
          variables: payload,
          errorPolicy: 'all',
          fetchPolicy: 'network-only',
        });
        debugLog('response: ', response);
        this.kanvaso = response.data.kanvasojKanvaso.edges;
        return Promise.resolve(response);
      } catch (err) {
        return Promise.reject(err);
      }
    },

    async onEditKanvaso(
      //   {
      //   publikigo,
      //   nomo,
      //   priskribo,
      //   posedantoUzantoId,
      //   uuid,
      //   forigo
      // }

      payload
    ) {
      debugLog('on edit kanvaso');
      try {
        const response = await apollo.default.mutate({
          mutation: kanvasoEdit,
          variables: payload,
          errorPolicy: 'all',
          fetchPolicy: 'network-only',
        });
        debugLog('response: ', response);
        // this.kanvaso = response.data.kanvasojKanvaso.edges;
        return Promise.resolve(response);
      } catch (err) {
        return Promise.reject(err);
      }
    },
  },
});

if (import.meta.hot) {
  import.meta.hot.accept(acceptHMRUpdate(useKanvasoStore, import.meta.hot));
}
