// @ts-nocheck

import { COLOR_LIGHT, COLOR_PRIMARY, COLOR_DARK } from './Const';
import CreateColumnPanel from './CreateColumnPanel';
import AddDragDropColumnPanelBehavior from './AddDragDropColumnPanelBehavior';

type Scene = {
  rexUI: {
    add: {
      sizer: (config: SizerConfig) => Sizer;
    };
  };
};

type SizerConfig = {
  orientation: string;
  space: {
    left: number;
    right: number;
    top: number;
    bottom: number;
  };
};

type Sizer = {
  add: (item: any, config: any) => void;
};

const CreateColumnPanelsBox = (
  scene: Scene,
  itemCountArray: number[]
): Sizer => {
  const config: SizerConfig = {
    orientation: 'x',
    space: {
      left: 10,
      right: 10,
      top: 10,
      bottom: 10,
    },
  };

  const columnPanelsBox: Sizer = scene.rexUI.add.sizer(config);
  // .addBackground(
  //     scene.rexUI.add.roundRectangle({
  //         strokeColor: COLOR_PRIMARY,
  //         strokeWidth: 3,
  //     }),
  //     'background'
  // )

  for (let i = 0, cnt = itemCountArray.length; i < cnt; i++) {
    const columnPanel = CreateColumnPanel(
      scene,
      `Header ${i}`,
      itemCountArray[i]
    );
    columnPanelsBox.add(columnPanel, { proportion: 0, expand: true });
  }

  AddDragDropColumnPanelBehavior(columnPanelsBox); // Убедитесь, что функция AddDragDropColumnPanelBehavior определена где-то в вашем коде

  return columnPanelsBox;
};

export default CreateColumnPanelsBox;
