extends Spatial

var choose = false

func _ready():
	for i in get_children():
		if has_signal(i,"new_way_point"):
			i.connect("new_way_point",self,"set_way_point")

func _input(event):
	if Input.is_action_just_pressed("ui_select"):
		choose=!choose
		if choose:
			$main_camera.set_privot($ship)
		else:
			$main_camera.set_privot(null)

func set_way_point(position,dock):
	# print(position)
	#останавливаем таймер
	$"ship/timer".stop()
	#передаём текущие координаты
	$ship.vojkomenco()#начинаем движение
	#запускаем таймер
	$"ship/timer".start()
	$ship.set_way_point(position,dock)
	$way_point.set_way_point(position)

func has_signal(node, sgnl):
	if node == null:
		return false
	node=node.get_signal_list()
	for i in node:
		if i.name == sgnl:
			return true
	return false




const QueryObject = preload("queries.gd")


func _on_space_ready():
	
	#космос сформирован
	var q = QueryObject.new()
	# Делаем запрос к бэкэнду
	$http_space_query.request(q.URL, Global.backend_headers, true, 2,
		 q.objecto_query(1, 2, 3, 2))



func _on_http_projekto_request_completed(result, response_code, headers, body):
	var resp = body.get_string_from_utf8()
	var parsed_resp = parse_json(resp)
	var simpled_data = parsed_resp['data']['redaktuUniversoProjekto']['universoProjekto']
	var uuid = simpled_data['uuid']
	$"ship".projekto_uuid=uuid
	# теперь создаём задачу с координатами
	var q = QueryObject.new()
	$"http_tasko".request(q.URL, Global.backend_headers, true, 2, q.instalo_tasko_posedanto_koord(
		$"ship".uuid, $"ship".projekto_uuid, 
		$"ship".translation.x, #kom_koordX
		$"ship".translation.y, #kom_koordY
		$"ship".translation.z, #kom_koordZ
		$"ship".way_point.x, #fin_koordX
		$"ship".way_point.y, #fin_koordY
		$"ship".way_point.z)) #fin_koordZ




func _on_http_tasko_request_completed(result, response_code, headers, body):
	var resp = body.get_string_from_utf8()
	var parsed_resp = parse_json(resp)
	var simpled_data = parsed_resp['data']['redaktuUniversoTaskoj']['universoTaskoj']
	var uuid = simpled_data['uuid']
	$ship.tasko_uuid=uuid
	# теперь присвоим владельца задаче
	var q = QueryObject.new()
	$http_posedanto.request(q.URL, Global.backend_headers, true, 2, 
		q.posedanto_tasko($"ship".uuid, uuid))


func _on_http_posedanto_request_completed(result, response_code, headers, body):
	var resp = body.get_string_from_utf8()
	var parsed_resp = parse_json(resp)
	pass


func _on_http_finado_request_completed(result, response_code, headers, body):
	var resp = body.get_string_from_utf8()
	var parsed_resp = parse_json(resp)
	pass # Replace with function body.
