extends KinematicBody

export var Sensitivity_X: float = 0.01
export var Sensitivity_Y: float = 0.01

const ZOOM_MIN = 1
const ZOOM_MAX = 50
const Zoom_Step: float = 1.0
#const MIN_ROT_Y = -1.55 #(89 градусов)
#const MAX_ROT_Y = 0.79 #(45 градусов)

var max_speed =1000.0
var current_speed =0
var acceleration = 500
var way_point: Vector3 = Vector3() # Координаты точки, в которую летим
var target_dir: Vector3 = Vector3.ZERO #направление на эту точку от текущей позиции корабля
var target_rot #положение корабля, которое надо принять, чтобы нацелиться на точку.
var speed_rotation =0.03
var middle_mouse_pressed = false
var docking_rotation
var uuid
var projekto_uuid
var tasko_uuid

func _ready():
	pass

func _physics_process(delta):
	
	if target_dir != Vector3.ZERO: #Если цель существует, двигаемся
		target_dir = (way_point - translation).normalized()
		
		if translation.distance_to(way_point) > max_speed*9/acceleration:
			current_speed += acceleration*delta
			current_speed =clamp(current_speed,10,max_speed)
			transform.basis = Basis(Quat(transform.basis).slerp(target_rot,speed_rotation)) #потихоньку поворачиваем корабль на цель. Взято у Сканера из урока про зомбей. Quat(transform.basis) - текущий поворот корабля
		else:
			if translation.distance_to(way_point) <0.01:
				if docking_rotation !=null:
					transform.basis = Basis(Quat(docking_rotation))
				translation = way_point
				clear_way_point()
				print("doexali")
				# останавливаем таймер передачи данных на сервер
				$timer.stop()
				#отправка последних координат и закрытие зачачи с проектом
				finofara_flugo()
				return
			current_speed -= acceleration*delta
			current_speed =clamp(current_speed,100,max_speed)
			if docking_rotation != null:
				transform.basis = Basis(Quat(transform.basis).slerp(docking_rotation,speed_rotation*1.5)) #поворачиваем в дефолтное состояние, чтобы сесть
		#print(translation.distance_to(way_point),": ",current_speed)		
		move_and_slide(target_dir*delta*current_speed) #Двигаемся к цели
		

func set_way_point(position, dock):
	docking_rotation = dock
	way_point = position # устанавливаем точку цели
	target_dir = (way_point - translation).normalized() # устанавливаем направление движение на цель.
	target_rot = Quat(transform.looking_at(way_point,Vector3.UP).basis) #запоминаем в какое положение надо установить корабль, чтобы нос был к цели. Это в кватернионах. ХЗ что это, но именно так вращать правильнее всего.
		
func clear_way_point():
	target_dir = Vector3.ZERO #очищаем цель
	way_point = Vector3.ZERO
	docking_rotation = null
	current_speed = 0




const QueryObject = preload("../skriptoj/queries.gd")

func _on_timer_timeout():
	var q = QueryObject.new()
	# Делаем запрос к бэкэнду
	$"../http_mutate".request(q.URL, Global.backend_headers, true, 2, 
		q.objecto_mutation(uuid, $"../ship".translation.x, 
			$"../ship".translation.y, $"../ship".translation.z,
			$"../ship".rotation.x, 
			$"../ship".rotation.y, $"../ship".rotation.z)
	)

func vojkomenco():
	var q = QueryObject.new()
	if !projekto_uuid:#если проекта нет, то создаём
		$"../http_projekto".request(q.URL, Global.backend_headers, true, 2, q.instalo_projekto())
	else:#проект есть, изменяем задачу
		# ставим задачу в выполененную
		# надо использовать другой request, не от поседанто, т.к. поседанто используется при /
		#   установке владельца задачи и этот может не успеть отработать
		$"../http_finado".request(q.URL, Global.backend_headers, true, 2, 
			q.finado_tasko(tasko_uuid))
		# и создаём новую задачу
		$"../http_tasko".request(q.URL, Global.backend_headers, true, 2, q.instalo_tasko_koord(
			$"../ship".uuid, $"../ship".projekto_uuid, 
			$"../ship".translation.x, #kom_koordX
			$"../ship".translation.y, #kom_koordY
			$"../ship".translation.z, #kom_koordZ
			$"../ship".way_point.x, #fin_koordX
			$"../ship".way_point.y, #fin_koordY
			$"../ship".way_point.z)) #fin_koordZ
	

func finofara_flugo():
	if projekto_uuid:
		var q = QueryObject.new()
		$"../http_finado".request(q.URL, Global.backend_headers, true, 2, 
			q.finado_projeko_tasko(projekto_uuid, tasko_uuid))
		projekto_uuid=''
		tasko_uuid=''
	pass
