extends Object
# Здесь будем хранить всё для запросов к бэкэнду по блоку "Космос"


# URL к API
const URL = "https://t34.tehnokom.su/api/v1.1/"


# Запрос к API
func objecto_query(kuboId, statusoId, kategorioId, tipo_id):
	return JSON.print({ "query": "query ($kuboId:Float, $statusoId:Float, $kategorioId:Float, "+
		" $tipoId:Float) { universoObjekto (kubo_Id: $kuboId,  koordinatoX_Gt:-5000000, "+
		" koordinatoY_Gt:-5000000, koordinatoZ_Gt:-5000000) { edges { node { uuid posedantoId "+
		" tasko (statuso_Id: $statusoId, kategorio_Id: $kategorioId, tipo_Id: $tipoId){ "+
		" edges { node { uuid finKoordinatoX finKoordinatoY finKoordinatoZ projekto { uuid } } } } "+
		"inCosmo nomo { enhavo } priskribo { enhavo } resurso { nomo { enhavo } priskribo { enhavo } "+
		"tipo { objId nomo { enhavo } } } koordinatoX koordinatoY koordinatoZ "+
		" rotaciaX rotaciaY rotaciaZ } } } }",
		'variables': {"kuboId":kuboId, "statusoId":statusoId, "kategorioId":kategorioId, "tipoId":tipo_id} })

func objecto_mutation(uuid, koordX, koordY, koordZ, rotaciaX, rotaciaY, rotaciaZ):
	return JSON.print({ 'query': 'mutation ($uuid:UUID, $koordX:Float, $koordY:Float, $koordZ:Float,'+
		' $rotaciaX:Float, $rotaciaY:Float, $rotaciaZ:Float )'+
		' { redaktuUniversoObjekto ( uuid: $uuid, koordinatoX: $koordX, koordinatoY: $koordY, '+
		'koordinatoZ: $koordZ, rotaciaX: $rotaciaX, rotaciaY: $rotaciaY, rotaciaZ: $rotaciaZ ) '+
		' { status message universoObjektoj { uuid } } }',
		'variables': {"uuid":uuid, "koordX": koordX, "koordY": koordY, "koordZ": koordZ,
		"rotaciaX": rotaciaX, "rotaciaY": rotaciaY, "rotaciaZ": rotaciaZ} })


func instalo_projekto():
	var tipoId = 2
	var kategorio = 3
	var statusoId = 2
	var nomo = "Movado"
	var priskribo = "Movado de objekto"
	return JSON.print({ 'query': 'mutation ($tipoId:Int, $kategorio:[Int],'+
		' $nomo:String, $priskribo:String, $statusoId:Int) { redaktuUniversoProjekto ( '+
		' tipoId:$tipoId, kategorio:$kategorio, nomo:$nomo, '+
		' priskribo:$priskribo, statusoId:$statusoId, publikigo:true ) { status message '+
		' universoProjekto { uuid } } }',
		'variables': {"tipoId":tipoId, "kategorio": kategorio, "nomo": nomo,
			"priskribo": priskribo, "statusoId": statusoId} })


func instalo_tasko_posedanto_koord(uuid, projekto_uuid, kom_koordX, kom_koordY, kom_koordZ,
		fin_koordX, fin_koordY, fin_koordZ):
	# создаём задачу, создаём владельца проекта, устанавливаем координаты объекту
	var tipoId = 2
	var kategorio = 3
	var statusoId = 2
	var nomo = "Movado"
	var priskribo = "Movado de objekto"
	var tipoPosedantoId = 1
	var statusoPosedantoId = 1
	return JSON.print({ 'query': 'mutation ($uuid:UUID, $koordX:Float, $koordY:Float, $koordZ:Float, '+
		'$tipoId:Int, $kategorio:[Int], $nomo:String, $priskribo:String, $statusoId:Int, $projekto_uuid: String,'+
		'$fin_koordX:Float, $fin_koordY:Float, $fin_koordZ:Float, $tipoPosedantoId:Int, $statusoPosedantoId:Int,'+
		'$posedantoObjektoUuid:String)'+
		' { redaktuUniversoObjekto ( uuid: $uuid, koordinatoX: $koordX, koordinatoY: $koordY, '+
		'koordinatoZ: $koordZ ) { status message universoObjektoj { uuid } } '+
		'redaktuUniversoProjektoPosedantoj( projektoUuid: $projekto_uuid, tipoId:$tipoPosedantoId, '+
		' posedantoObjektoUuid: $posedantoObjektoUuid, statusoId:$statusoPosedantoId, publikigo:true ) '+
		' { status message universoProjektoPosedantoj{ uuid } }'+
		' redaktuUniversoTaskoj (projektoUuid: $projekto_uuid, tipoId:$tipoId, kategorio:$kategorio, nomo:$nomo, '+
		' priskribo:$priskribo, statusoId:$statusoId, publikigo:true, komKoordinatoX:$koordX,'+
		' komKoordinatoY:$koordY, komKoordinatoZ:$koordZ, finKoordinatoX:$fin_koordX,'+
		' finKoordinatoY:$fin_koordY, finKoordinatoZ:$fin_koordZ) { status '+
		' message universoTaskoj { uuid } } }',
		'variables': {"uuid":uuid, "koordX": kom_koordX, "koordY": kom_koordY, "koordZ": kom_koordZ,
		"tipoId":tipoId, "kategorio": kategorio, "nomo": nomo, "priskribo": priskribo, 
		"statusoId": statusoId, "projekto_uuid": projekto_uuid, "fin_koordX":fin_koordX, 
		"fin_koordY":fin_koordY, "fin_koordZ":fin_koordZ, "tipoPosedantoId":tipoPosedantoId,
		"statusoPosedantoId":statusoPosedantoId, "posedantoObjektoUuid":uuid} })


func posedanto_tasko(uuid, tasko_uuid):
	# создаём владельца задачи
	var tipoPosedantoId = 1
	var statusoPosedantoId = 1
	return JSON.print({ 'query': 'mutation ($uuid:String, '+
		' $tasko_uuid: String,'+
		' $tipoPosedantoId:Int, $statusoPosedantoId:Int)'+
		' { redaktuUniversoTaskoPosedantoj( taskoUuid: $tasko_uuid, tipoId:$tipoPosedantoId, '+
		' posedantoObjektoUuid: $uuid, statusoId:$statusoPosedantoId, publikigo:true ) '+
		' { status message universoTaskoPosedantoj{ uuid } } }',
		'variables': {"uuid":uuid, "tasko_uuid": tasko_uuid, "tipoPosedantoId":tipoPosedantoId,
		"statusoPosedantoId":statusoPosedantoId} })
	

func instalo_tasko_koord(uuid, projekto_uuid, kom_koordX, kom_koordY, kom_koordZ,
		fin_koordX, fin_koordY, fin_koordZ):
	# создаём задачу, устанавливаем координаты объекту
	var tipoId = 2
	var kategorio = 3
	var statusoId = 2
	var nomo = "Movado"
	var priskribo = "Movado de objekto"
	return JSON.print({ 'query': 'mutation ($uuid:UUID, $koordX:Float, $koordY:Float, $koordZ:Float, '+
		'$tipoId:Int, $kategorio:[Int], $nomo:String, $priskribo:String, $statusoId:Int, $projekto_uuid: String,'+
		'$fin_koordX:Float, $fin_koordY:Float, $fin_koordZ:Float )'+
		'{ redaktuUniversoObjekto ( uuid: $uuid, koordinatoX: $koordX, koordinatoY: $koordY, '+
		' koordinatoZ: $koordZ ) { status message universoObjektoj { uuid } } '+
		'redaktuUniversoTaskoj (projektoUuid: $projekto_uuid, tipoId:$tipoId, kategorio:$kategorio, nomo:$nomo, '+
		' priskribo:$priskribo, statusoId:$statusoId, publikigo:true, komKoordinatoX:$koordX,'+
		' komKoordinatoY:$koordY, komKoordinatoZ:$koordZ, finKoordinatoX:$fin_koordX,'+
		' finKoordinatoY:$fin_koordY, finKoordinatoZ:$fin_koordZ) { status '+
		' message universoTaskoj { uuid } } }',
		'variables': {"uuid":uuid, "koordX": kom_koordX, "koordY": kom_koordY, "koordZ": kom_koordZ,
		"tipoId":tipoId, "kategorio": kategorio, "nomo": nomo, "priskribo": priskribo, 
		"statusoId": statusoId, "projekto_uuid": projekto_uuid, "fin_koordX":fin_koordX, 
		"fin_koordY":fin_koordY, "fin_koordZ":fin_koordZ } })


# завершение задачи
func finado_tasko(tasko_uuid):
	var statusoId = 4
	return JSON.print({ 'query': 'mutation ($uuid:UUID,  '+
		' $statusoId:Int, )'+
		'{ redaktuUniversoTaskoj (uuid: $uuid,  '+
		' statusoId:$statusoId) { status '+
		' message universoTaskoj { uuid } } }',
		'variables': {"uuid":tasko_uuid, "statusoId": statusoId } })


# завершение задачи
func finado_projeko_tasko(projekto_uuid, tasko_uuid):
	var statusoId = 4
	return JSON.print({ 'query': 'mutation ($tasko_uuid:UUID, $projekto_uuid:UUID, '+
		' $statusoId:Int, )'+
		'{ redaktuUniversoTaskoj (uuid: $tasko_uuid,  '+
		' statusoId:$statusoId) { status '+
		' message universoTaskoj { uuid } } '+
		' redaktuUniversoProjekto (uuid: $projekto_uuid,  '+
		' statusoId:$statusoId) { status '+
		' message universoProjekto { uuid } } '+
		'}',
		'variables': {"tasko_uuid":tasko_uuid, "statusoId": statusoId, "projekto_uuid":projekto_uuid } })
