extends HTTPRequest

const ship = preload("res://blokoj/kosmo/scenoj/ships.tscn")

func _on_http_space_query_request_completed(result, response_code, headers, body):
	var resp = body.get_string_from_utf8()
	var parsed_resp = parse_json(resp)
	var simpled_data = parsed_resp['data']['universoObjekto']['edges']
	for item in simpled_data:
		if item['node']['resurso']['tipo']['objId'] == 3:
			$"../space_object".translation=Vector3(item['node']['koordinatoX'],
				item['node']['koordinatoY'], item['node']['koordinatoZ'])
			$"../space_object".visible=true
		if item['node']['resurso']['tipo']['objId'] == 2:
			#если корабль игрока
			if item['node']['posedantoId'] == Global.id:
				$"../ship".translation=Vector3(item['node']['koordinatoX'],
					item['node']['koordinatoY'], item['node']['koordinatoZ'])
				$"../ship".rotation=Vector3(item['node']['rotaciaX'],
					item['node']['rotaciaY'], item['node']['rotaciaZ'])
				$"../main_camera".translation=Vector3(item['node']['koordinatoX'],
					item['node']['koordinatoY'], item['node']['koordinatoZ']+22)
				$"../ship".visible=true
				$"../ship".uuid=item['node']['uuid']
				# и теперь по uuid нужно найти проект и задачу
				print('подошли к чтению проектов/задач = ',item['node']['tasko']['edges'])
				var taskoj = item['node']['tasko']['edges']
				if len(taskoj)>1:
					pass #нужно обнулить все задачи!!!
				if len(taskoj)>0:
					var tasko = taskoj[0]['node']
					print('устанавливаем задачу = ',taskoj[0]['node']['uuid'])
					$"../ship".tasko_uuid=taskoj[0]['node']['uuid']
					#отправляем корабль по координатам
					var position = Vector3(tasko['finKoordinatoX'],tasko['finKoordinatoY'],tasko['finKoordinatoZ'])
					var dock = Vector3(0,0,0)
					print('пробуем отправить корабль')
					$"../ship".set_way_point(position,dock)
					$"../way_point".set_way_point(position)
					$"../ship/timer".start()
				
					print('устанавливаем проект = ',taskoj[0]['node']['projekto']['uuid'])
					$"../ship".projekto_uuid=taskoj[0]['node']['projekto']['uuid']
				else:
					$"../ship".tasko_uuid=''
					$"../ship".projekto_uuid=''
			else:
				var s = ship.instance()
				s.translation=Vector3(item['node']['koordinatoX'],
					item['node']['koordinatoY'], item['node']['koordinatoZ'])
				$"../".add_child(s)




