extends HTTPRequest

const ship = preload("res://blokoj/kosmo/scenoj/ships.tscn")

func _on_http_space_query_request_completed(result, response_code, headers, body):
	var resp = body.get_string_from_utf8()
	var parsed_resp = parse_json(resp)
	var simpled_data = parsed_resp['data']['universoObjekto']['edges']
	#print('simpled_data=',simpled_data)

	for item in simpled_data:
		if item['node']['resurso']['tipo']['objId'] == 3:
			$"../space_object".translation=Vector3(item['node']['koordinatoX'],
				item['node']['koordinatoY'], item['node']['koordinatoZ'])
			$"../space_object".visible=true
		if item['node']['resurso']['tipo']['objId'] == 2:
			#если корабль игрока
			if item['node']['posedantoId'] == Global.id:
				$"../ship".translation=Vector3(item['node']['koordinatoX'],
					item['node']['koordinatoY'], item['node']['koordinatoZ'])
				$"../main_camera".translation=Vector3(item['node']['koordinatoX'],
					item['node']['koordinatoY'], item['node']['koordinatoZ']+22)
				$"../ship".visible=true
				$"../ship".uuid=item['node']['uuid']
			else:
				var s = ship.instance()
				s.translation=Vector3(item['node']['koordinatoX'],
					item['node']['koordinatoY'], item['node']['koordinatoZ'])
				$"../".add_child(s)




