extends Object
# Здесь будем хранить всё для запросов к бэкэнду по блоку "rajtigo"


# URL к API (авторизация)
const URL_AUTH = "https://t34.tehnokom.su/api/v1.1/registrado/"
# URL к API
const URL_DATA = "https://t34.tehnokom.su/api/v1.1/"


# Запрос авторизации
func auth_query(login, password):
	return JSON.print({ "query": "mutation { ensaluti(login: \"%s\", password: \"%s\") { status token message csrfToken uzanto { objId } } }" % [login, password] })


# Запрос никнейма
func get_nickname_query(id):
	return JSON.print({ "query": "query { universoUzanto(siriusoUzantoId: %s) { edges { node { uuid retnomo } } } }" % id })


# запрос на список управляемых объектов
func get_direktebla_query(statusoId, kategorioId, tipoId):
	var query = JSON.print({ "query": "query ($UzantoId:Int, $statusoId:Float, "+
		" $kategorioId:Float, $tipoId:Float)"+
		"{ universoObjekto (" +
		" universoobjektouzanto_Isnull:false,"+
		" universoobjektouzanto_Autoro_SiriusoUzanto_Id:$UzantoId," +
		") { edges { node { uuid " +
		" projekto (statuso_Id: $statusoId, tipo_Id: $tipoId){ "+
		"  edges { node { uuid "+
		"  tasko (kategorio_Id:$kategorioId){ edges {node { "+
		"   uuid finKoordinatoX finKoordinatoY finKoordinatoZ statuso {objId} } } } } } } "+
		" nomo { enhavo } priskribo { enhavo } "+
		" resurso { objId nomo { enhavo } priskribo { enhavo } "+
		"  tipo { objId nomo { enhavo } } "+
		"  ligilo { edges { node { ligilo { "+
		"   objId nomo{enhavo} priskribo{enhavo} "+
		"   tipo{ objId nomo{enhavo} } } } } } "+
		" } "+
		" koordinatoX koordinatoY koordinatoZ "+
		' posedantoObjekto '+
		'  { uuid } '+
		" nomo{enhavo}" +
		" ligiloLigilo{edges{node{uuid "+
		"  posedanto{ kubo {objId} koordinatoX koordinatoY koordinatoZ }}}}" +
		" ligilo{edges{node{ ligilo{ nomo{enhavo} ligilo{edges{node{" +
		"  konektiloPosedanto konektiloLigilo" +
		"  ligilo{ uuid }}}}}" +
		"  tipo{objId}}}}" +
		" realeco{objId}" +
		" posedanto{edges{node{" +
		"  posedantoUzanto{ siriusoUzanto{ objId}}}}}" +
		" rotaciaX rotaciaY rotaciaZ } } } }",
		'variables': {"statusoId":statusoId, 
		"kategorioId":kategorioId, "tipoId":tipoId,
		"UzantoId":Global.id} })

	# print("=== get_direktebla_query = ",query)
	return query
	
