extends Object
# Здесь будем хранить всё для запросов к бэкэнду по блоку "Космос"


# URL к API
const URL = "https://t34.tehnokom.su/api/v1.1/"


# Запрос к API
func objecto_query(kuboId, statusoId, kategorioId, tipo_id):
	return JSON.print({ "query": "query ($kuboId:Float, $statusoId:Float, "+
		" $realecoId:Float, $kategorioId:Float, $tipoId:Float) " +
		"{ universoObjekto (realeco_Id:$realecoId, kubo_Id: $kuboId,  koordinatoX_Gt:-5000000, "+
		" koordinatoY_Gt:-5000000, koordinatoZ_Gt:-5000000) { edges { node { uuid posedantoId "+
		"projekto (statuso_Id: $statusoId, tipo_Id: $tipoId){ "+
		" edges { node { uuid "+
		"tasko (kategorio_Id:$kategorioId){ edges {node { "+
		"  uuid finKoordinatoX finKoordinatoY finKoordinatoZ statuso {objId} } } } } } } "+
		" inCosmo nomo { enhavo } priskribo { enhavo } resurso { nomo { enhavo } priskribo { enhavo } "+
		"tipo { objId nomo { enhavo } } } koordinatoX koordinatoY koordinatoZ "+
		" rotaciaX rotaciaY rotaciaZ } } } }",
		'variables': {"kuboId":kuboId, "statusoId":statusoId, 
		"kategorioId":kategorioId, "tipoId":tipo_id,
		"realecoId":Global.realeco} })


# задаём координаты и угол поворота объекту
func objecto_mutation(uuid, koordX, koordY, koordZ, rotaciaX, rotaciaY, rotaciaZ):
	return JSON.print({ 'query': 'mutation ($uuid:UUID, $koordX:Float, $koordY:Float, $koordZ:Float,'+
		' $rotaciaX:Float, $rotaciaY:Float, $rotaciaZ:Float )'+
		' { redaktuUniversoObjekto ( uuid: $uuid, koordinatoX: $koordX, koordinatoY: $koordY, '+
		'koordinatoZ: $koordZ, rotaciaX: $rotaciaX, rotaciaY: $rotaciaY, rotaciaZ: $rotaciaZ ) '+
		' { status message universoObjektoj { uuid } } }',
		'variables': {"uuid":uuid, "koordX": koordX, "koordY": koordY, "koordZ": koordZ,
		"rotaciaX": rotaciaX, "rotaciaY": rotaciaY, "rotaciaZ": rotaciaZ} })


# устанавливаем проект
func instalo_projekto(posedantoObjektoUuid, kom_koordX, kom_koordY, kom_koordZ,
	fin_koordX, fin_koordY, fin_koordZ):
	var tipoId = 2
	var kategorio = 3
	var statusoId = 2
	var nomo = "Movado"
	var priskribo = "Movado de objekto"
	var statusoPosedantoId = 1
	var tipoPosedantoId = 1
	var query = JSON.print({ 'query': 'mutation ($tipoId:Int, $kategorio:[Int],'+
		' $nomo:String, $priskribo:String, $statusoId:Int, $kom_koordX:Float, '+
		' $kom_koordY:Float, $kom_koordZ:Float, $fin_koordX:Float, '+
		' $fin_koordY:Float, $fin_koordZ:Float, $tipoPosedantoId:Int,'+
		' $statusoPosedantoId:Int, $posedantoObjektoUuid:String, '+
		' $realecoId:Int ) '+
		'{ redaktuUniversoProjekto ( '+
		' tipoId:$tipoId, kategorio:$kategorio, nomo:$nomo, '+
		' priskribo:$priskribo, statusoId:$statusoId, publikigo:true, komKoordinatoX:$kom_koordX,'+
		' komKoordinatoY:$kom_koordY, komKoordinatoZ:$kom_koordZ, finKoordinatoX:$fin_koordX,'+
		' finKoordinatoY:$fin_koordY, finKoordinatoZ:$fin_koordZ, posedantoTipoId:$tipoPosedantoId, '+
		' posedantoObjektoUuid: $posedantoObjektoUuid, posedantoStatusoId:$statusoPosedantoId ,'+
		' realecoId:$realecoId ) '+
		' { status message '+
		' universoProjekto { uuid } } }',
		'variables': {"tipoId":tipoId, "kategorio": kategorio, "nomo": nomo,
			"priskribo": priskribo, "statusoId": statusoId,
			"kom_koordX": kom_koordX, "kom_koordY": kom_koordY, "kom_koordZ": kom_koordZ, 
			"fin_koordX":fin_koordX, 
			"fin_koordY":fin_koordY, "fin_koordZ":fin_koordZ,
			"posedantoObjektoUuid":posedantoObjektoUuid, "statusoPosedantoId":statusoPosedantoId,
			"tipoPosedantoId":tipoPosedantoId, "realecoId":Global.realeco} })
	# print('===instalo_projekto===',query)
	return query

# записываем список задач с их владельцами и текущие координаты объекту
func instalo_tasko_posedanto_koord(uuid, projekto_uuid, kom_koordX, kom_koordY, kom_koordZ, itineroj):
	# создаём список задач, создаём владельца проекта, устанавливаем координаты объекту
	var tipoId = 2
	var kategorio = 3
	var statusoId = [2]
	var nomo = "Movado"
	var priskribo = "Movado de objekto"
	var tipoPosedantoId = 1
	var statusoPosedantoId = 1
	var pozicio =[1]
	var fin_koordX = []
	var fin_koordY = []
	var fin_koordZ = []
	# параметры координат последующих задач
	var i = 0
	var komKoordinatoX=[]
	var komKoordinatoY=[]
	var komKoordinatoZ=[]
	for iti in itineroj:
		if i==0:
			komKoordinatoX.append(kom_koordX)
			komKoordinatoY.append(kom_koordY)
			komKoordinatoZ.append(kom_koordZ)
		else:
			pozicio.append(i+1)
			komKoordinatoX.append(itineroj[i-1]['koordinatoX'])
			komKoordinatoY.append(itineroj[i-1]['koordinatoY'])
			komKoordinatoZ.append(itineroj[i-1]['koordinatoZ'])
			statusoId.append(1)
		fin_koordX.append(itineroj[i]['koordinatoX'])
		fin_koordY.append(itineroj[i]['koordinatoY'])
		fin_koordZ.append(itineroj[i]['koordinatoZ'])
		i += 1

	var query = JSON.print({ 'query': 'mutation ($uuid:UUID, $koordX:Float, $koordY:Float, $koordZ:Float, ' +
		'$tipoId:Int, $kategorio:[Int], $nomo:String, $priskribo:String, $statusoId:[Int], $projekto_uuid: String,' +
		'$komKoordinatoX:[Float], $komKoordinatoY:[Float], $komKoordinatoZ:[Float], $tipoPosedantoId:Int,' +
		'$fin_koordX:[Float], $fin_koordY:[Float], $fin_koordZ:[Float], $pozicio:[Int], $statusoPosedantoId:Int,' +
		'$posedantoObjektoUuid:String, $realecoId:Int)'+
		' { redaktuUniversoObjekto ( uuid: $uuid, koordinatoX: $koordX, koordinatoY: $koordY, '+
		' koordinatoZ: $koordZ, realecoId:$realecoId ) { status message universoObjektoj { uuid } } '+
		'redaktuKreiUniversoTaskojPosedanto (projektoUuid: $projekto_uuid, tipoId:$tipoId, kategorio:$kategorio, nomo:$nomo, '+
		' priskribo:$priskribo, statusoId:$statusoId, pozicio:$pozicio, komKoordinatoX:$komKoordinatoX,'+
		' komKoordinatoY:$komKoordinatoY, komKoordinatoZ:$komKoordinatoZ, finKoordinatoX:$fin_koordX,'+
		' finKoordinatoY:$fin_koordY, finKoordinatoZ:$fin_koordZ, posedantoStatusoId:$statusoPosedantoId,'+
		' posedantoTipoId:$tipoPosedantoId, posedantoObjektoUuid:$posedantoObjektoUuid, '+
		' realecoId:$realecoId ) { status '+
		' message universoTaskoj { uuid } } }',
		'variables':  {"uuid":uuid, "koordX": kom_koordX, "koordY": kom_koordY, "koordZ": kom_koordZ,
		"tipoId":tipoId, "kategorio": kategorio, "nomo": nomo, "priskribo": priskribo, 
		"statusoId": statusoId, "projekto_uuid": projekto_uuid, "fin_koordX":fin_koordX, 
		"fin_koordY":fin_koordY, "fin_koordZ":fin_koordZ, "tipoPosedantoId":tipoPosedantoId,
		"statusoPosedantoId":statusoPosedantoId, "posedantoObjektoUuid":uuid, "pozicio":pozicio,
		"komKoordinatoX":komKoordinatoX, "komKoordinatoY":komKoordinatoY, "komKoordinatoZ":komKoordinatoZ,
		"realecoId":Global.realeco}})
	# print('===instalo_tasko_posedanto_koord===',query)
	return query


# func posedanto_tasko(uuid, tasko_uuid):
# 	# создаём владельца задачи
# 	var tipoPosedantoId = 1
# 	var statusoPosedantoId = 1
# 	return JSON.print({ 'query': 'mutation ($uuid:String, '+
# 		' $tasko_uuid: String,'+
# 		' $tipoPosedantoId:Int, $statusoPosedantoId:Int)'+
# 		' { redaktuUniversoTaskoPosedantoj( taskoUuid: $tasko_uuid, tipoId:$tipoPosedantoId, '+
# 		' posedantoObjektoUuid: $uuid, statusoId:$statusoPosedantoId, publikigo:true ) '+
# 		' { status message universoTaskoPosedantoj{ uuid } } }',
# 		'variables': {"uuid":uuid, "tasko_uuid": tasko_uuid, "tipoPosedantoId":tipoPosedantoId,
# 		"statusoPosedantoId":statusoPosedantoId} })
	

# создаём задачу, устанавливаем координаты объекту, изменяем финальные координаты проекту
func instalo_tasko_koord(uuid, projekto_uuid, kom_koordX, kom_koordY, kom_koordZ,
		fin_koordX, fin_koordY, fin_koordZ):
	var posedantoTipoId = 1
	var posedantoStatusoId = 1
	var tipoId = 2
	var kategorio = 3
	var statusoId = 2
	var nomo = "Movado"
	var priskribo = "Movado de objekto"
	return JSON.print({ 'query': 'mutation ($uuid:UUID, $koordX:Float, $koordY:Float, $koordZ:Float, '+
		'$tipoId:Int, $kategorio:[Int], $nomo:String, $priskribo:String, $statusoId:Int, $projekto_uuid: UUID,'+
		'$fin_koordX:Float, $fin_koordY:Float, $fin_koordZ:Float, $projektoUuid: String, '+
		'$posedantoTipoId:Int, $posedantoStatusoId:Int, $posedantoObjektoUuid:String, '+
		'$realecoId:Int)'+
		'{ redaktuUniversoObjekto ( uuid: $uuid, koordinatoX: $koordX, koordinatoY: $koordY, '+
		' koordinatoZ: $koordZ, realecoId:$realecoId ) { status message universoObjektoj { uuid } } '+
		'redaktuUniversoTaskoj (projektoUuid: $projektoUuid, tipoId:$tipoId, kategorio:$kategorio, nomo:$nomo, '+
		' priskribo:$priskribo, statusoId:$statusoId, publikigo:true, komKoordinatoX:$koordX,'+
		' komKoordinatoY:$koordY, komKoordinatoZ:$koordZ, finKoordinatoX:$fin_koordX,'+
		' finKoordinatoY:$fin_koordY, finKoordinatoZ:$fin_koordZ, posedantoTipoId:$posedantoTipoId, '+
		' posedantoObjektoUuid:$posedantoObjektoUuid, posedantoStatusoId:$posedantoStatusoId, '+
		' realecoId:$realecoId) '+
		'{ status '+
		' message universoTaskoj { uuid } } '+
		'redaktuUniversoProjekto ( uuid:$projekto_uuid ,'+
		' finKoordinatoX:$fin_koordX,'+
		' finKoordinatoY:$fin_koordY, finKoordinatoZ:$fin_koordZ ) '+
		' { status message '+
		' universoProjekto { uuid } } }',
		'variables': {"uuid":uuid, "koordX": kom_koordX, "koordY": kom_koordY, "koordZ": kom_koordZ,
		"tipoId":tipoId, "kategorio": kategorio, "nomo": nomo, "priskribo": priskribo, 
		"statusoId": statusoId, "projekto_uuid": projekto_uuid, "projektoUuid": projekto_uuid, 
		"fin_koordX":fin_koordX, "fin_koordY":fin_koordY, "fin_koordZ":fin_koordZ,
		"posedantoStatusoId":posedantoStatusoId, "posedantoTipoId":posedantoTipoId,
		"posedantoObjektoUuid":uuid, "realecoId":Global.realeco } })


# завершение задачи
func finado_tasko(tasko_uuid, statusoId = 4):
	return JSON.print({ 'query': 'mutation ($uuid:UUID,  '+
		' $statusoId:Int, )'+
		'{ redaktuUniversoTaskoj (uuid: $uuid,  '+
		' statusoId:$statusoId) { status '+
		' message universoTaskoj { uuid } } }',
		'variables': {"uuid":tasko_uuid, "statusoId": statusoId } })


# завершение задачи и проекта
func finado_projeko_tasko(projekto_uuid, tasko_uuid):
	var statusoId = 4
	return JSON.print({ 'query': 'mutation ($tasko_uuid:UUID, $projekto_uuid:UUID, '+
		' $statusoId:Int, )'+
		'{ redaktuUniversoTaskoj (uuid: $tasko_uuid,  '+
		' statusoId:$statusoId) { status '+
		' message universoTaskoj { uuid } } '+
		'redaktuUniversoProjekto (uuid: $projekto_uuid,  '+
		' statusoId:$statusoId) { status '+
		' message universoProjekto { uuid } } '+
		'}',
		'variables': {"tasko_uuid":tasko_uuid, "statusoId": statusoId, "projekto_uuid":projekto_uuid } })
