# Welcome to AFFiNE Abbey Alpha Wood

We've been working hard on improving the user experience and have made several new features live for you to use.

If you are looking for **support**, would like to **suggest** your ideas, and keep on top of all the **latest updates**. We suggest you visit the [AFFiNE Community](https://community.affine.pro/home) site.

Let us know what you think of this latest version.

**AFFiNE Alpha brings:**

1. A much smoother editing experience, with much greater stability;
2. More complete Markdown support and improved keyboard shortcuts;
3. New features such as dark mode; Switch between view styles using the ☀ and 🌙.
4. Clean and modern UI/UX design.
5. You can self-host locally with Docker.

```basic
docker run -it --name affine -d -v [YOUR_PATH]:/app/data -p 3000:3000 ghcr.io/toeverything/affine-self-hosted:alpha-abbey-wood
```

**Looking for Markdown syntax or keyboard shortcuts?**

- Find the (?) in the bottom right, then the ️⌨️, to view a full list of Keyboard Shortcuts

### In this release, you can now:

- Manage your pages from the collapsible **sidebar**, which allows you to add **favorites** and restore deleted files from the **trash**
- Search through all your content with the quick search - activate with `Ctrl/⌘ + K`
  - A friendly Reminder:
    - In the case of unselected text, `Ctrl/⌘ + K` activates quick search;
    - In the case of selected text, `Ctrl/⌘ + K` will firstly ask to add a hyperlink, and then using `Ctrl/⌘ + K` again activates the quick search
- Quickly format text with the **pop-up toolbar** (highlight any text to give it a try)
- Copy and paste **images** into your pages, resize them and add captions
- Add horizontal line dividers to your text with `---` and `***`
- Changes are saved **locally**, but we still recommend you export your data to avoid data loss
- Insert code blocks with syntax highlighting support using `````

### Playground:

[] Try a horizontal line: `---`

[] What about a code block? `````

```JavaScript
console.log('Hello world');
```

[] Can you resize this image?

![](https://cdn.affine.pro/694fdbab78e0da3ed7922eba7d506dcf12f57308e1904dd694f53eb2.jpg)

**How about page management?**

[] Create a new page

[] Send a page to trash

[] Favorite a page

**Have an enjoyable editing experience !!!** 😃

Have some feedback or just want to get in touch? Use the (?), then 🎧 to get in touch and join our communities.

**Interested in AFFiNE cloud?**

Head over to [general](https://community.affine.pro/c/general-discussion/) in our community and post what interests you about AFFiNE!
