# Issues Triaging

When we receive your issue, we will first triaging it. Triaging an issue usually takes around one business day but may take longer. Goal of triaging is to provide you with a clear understanding of what will happen to your issue. For example, after your feature request was triaged you know whether we plan to tackle the issue or whether we'll wait to hear what the broader community thinks about this request.

Here are issue states and their descriptions:

| State               | Description                                                                                                                                                                                                                           |
| ------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Untriaged           | The team has not yet reviewed the issue. We usually do it within one business day.                                                                                                                                                    |
| As designed         | The behavior described in the issue is intentional. If you find it seriously disruptive or if we’ve misunderstood you, please let us know in the issue’s comments section.                                                            |
| Blocked             | We can’t work on this issue until another one (linked) is resolved.                                                                                                                                                                   |
| Can’t Reproduce     | We have been unable to reproduce the issue on our side. It could be flaky or fixed already, or we may not have had all the details we needed. If you’re still experiencing the issue and have any further details, please share them. |
| Duplicate           | The issue is the same (or has the same cause) as another one (linked).                                                                                                                                                                |
| Fixed               | If the issue was a bug, it’s been fixed; if it was a missing feature, it’s been implemented.                                                                                                                                          |
| Fixed In Branch     | If the issue was a bug, it’s been fixed; if it was a missing feature, it’s been implemented; the changes are now in a separate branch and haven’t been merged into the default branch yet.                                            |
| In Progress         | We’re currently working on the issue.                                                                                                                                                                                                 |
| Incomplete          | Unfortunately we don’t have enough information to proceed. If you’re willing to share any further details about the issue, please do so in the comments.                                                                              |
| Obsolete            | The part of the product that was causing this issue has been removed or significantly reworked since it was created.                                                                                                                  |
| Upvoting            | We are currently evaluating demand for the issue and checking whether it requires complicated or risky changes. Please leave a vote or comment if you think it should be prioritized.                                                 |
| Open                | We want to implement the fix or feature in the near future. We can’t promise it will appear in the next public release, but it’s on our short list.                                                                                   |
| Shelved             | We have reviewed the issue and decided that, even though it has merit, we cannot currently include it in our near-term plan.                                                                                                          |
| Third Party Problem | The issue is caused by a third party. We've done our best to inform them about it.                                                                                                                                                    |
| To be Discussed     | We need some time to discuss the issue.                                                                                                                                                                                               |
| To Reproduce        | We will try to find the steps needed to reproduce the issue on our side.                                                                                                                                                              |
| Under Investigation | We’ve triaged the issue, but now we need to investigate it more thoroughly. This may require processing additional information like logs or dumps.                                                                                    |
| Waiting for Info    | We’ve requested additional information from the person who created the issue and are waiting for them to get back to us.                                                                                                              |
| Declined            | We’ve reviewed the suggestion and, while we appreciate its value, we unfortunately do not have the resources to implement it.                                                                                                         |
| Answered            | The issue actually turned out to be a question or a misunderstanding, and it has been answered or resolved.                                                                                                                           |
