# Модуль 1 — Анализ проекта и организация работы

## Правила работы с модулем

1. Рекомендуется включить запись работы с модулем.
2. Модуль нужно пройти и повторить минимум один раз. В первом подходе куратор излагает модуль учащемуся, на следующих подходах учащийся старается по память воспроизвести всю информацию и навыки из модуля.

## Цель модуля

Научиться правильно получать первичную информацию о проекте, приступать к реализации проекта переводя первичные запросы заказчика в проектную форму, какие инструменты использовать, в частности GitLab.

## Основная информация

Начинаем нашу работу по суперинтенсиву. Работа разделена на учебные модули. В начале модули будет посвящены тому, как правильно начать проект, как организовать работу, как правильно получать и передавать информацию другим участникам работы. Правильная организация работы — это более 50% успеха, в некоторых случаях это даже 99% успеха.

Я сейчас буду давать тебе различную информацию, если тебе что-то ранее было известно, не нужно говорить, что ты это знаешь, что это можно пропустить и так далее. Нам нужно пройти всю учебную информацию и много раз её повторить, чтобы всю эту информацию хорошо запомнить и понимать как полученные знания можно дальше применять.

## Организация работы

Любой программный проект, который создаётся, нужно начинать с создания для него проекта / репозитория, например, в GitLab.com, даже в случае, если не планируется использовать какой-то другой функционал, кроме функционала хранения кода, даже если это наш личный проект и мы планируем с ним работать на локальном компьютере. Это связано с тем, что на локальном компьютере может произойти много разных ситуаций, которые приведут к потере как отдельного кода, так и всего проекта. Вирусы, глюк программного обеспечения, поломка жёсткого диска и т.д.

Иногда это может казаться не важным, но если не приобрести привычку, вести разработку правильно, в том числе регулярно отправлять на хранение свой код в сервис хранения кода, это будет регулярно приводить к потерям важного кода, на который потрачено много времени и денег.

Понятно почему важно сразу работать с онлайн сервисом хранения кода? Почему это важно, расскажи, пожалуйста?

## Работа с заказчиком

Заказчиком можешь выступать ты сам, заказчиком может быть, какой-то сторонний субъект (человек, организация), заказчиком может быть так называемый внутренний заказчик — это представитель того коллектива или организации в которой ты делаешь проект, это может быть аналитик, работник какого-то подразделения для которого требуется какая-то работа и так далее.

Вне зависимости то того, каким образом мы будем получать информацию от заказчика, это может быть даже не просто разговор, а может быть зафиксировано в текстах через почту или мессенджеры, всё равно без полноценного проектного подхода вся эта информация будет плохо структурирована, будет накапливаться различие в понимание разных вопросов, что в конечном итоге будет снижать эффективность работы, приводить к необходимости переделывать различную работу, будет с каждым шагом повышать вероятность конфликтов и провала работы.
Но правильно структурировать информацию поступающую от заказчика — это не единственное важное, что нужно сделать при запуске работы. Важно всю информацию, которая поступает от заказчика, критически переосмыслить. Понять, действительно ли ему нужно то, о чём он говорит, понимает ли заказчик текущую цель и дальнейшие перспективы развития проекта.

## Далее по модулю нужно сделать:

- Рассказать пример общения с заказчиком.

- Создать новый репозиторий в  GitLab.com.

- В репозитории создать первую задачу (Issue).

- В репозитории создать метки (Labels).

- В репозитории создать этапы (Milestones).

- В первой задаче выставить метки и этап.

- Сделать базовое редактирование главного README.md репозитория.

## При повторении:

Сначала нужно удалить предыдущий репозиторий. При удалении сначала у репозитория нужно поменять URL, на случай если он на некоторое время заморозится, чтобы не занимал это имя в URL, которое нам может пригодиться в другом репозитории.

Потом создать новый репозиторий и повторить все действия. Учайщийся должен стараться все сделать сам, в том числе рассказать зачем всё это делается, какие результаты планируются получить.