# РВМ Универсо

Реальный виртуальный мир Универсо (РВМ Универсо) предоставляет доступ в Гипервселенную, где вы можете в своих или общих метавселенных создавать цифровые двойники предприятий и целых городов, играть в простые игры и жить в гигантских MMORPG с развитой внутренней экономикой, вы получаете бесконечное пространство исследований, цифровизации и социального взаимодействия.

Функционал Общественного Кибергосплана, позволит трудящимся во всём мире объединяться в Народные предприятия, Профсоюзы, Советы, эффективно использовать ресурсы в рамках общего плана производства и т.д. Всё сначала можно смоделировать в виртуальных мирах, а потом перенести в реальный мир.

## Разработчики проекта и статус проекта

Проект находится в активной разработке, формируются еженедельные альфа-релизы. Разработка осуществляется Международным сообществом Текнокомо, в том числе ассоциированными организациями, такими как народное предприятие производственный кооператив "Советские роботы", а также людьми и организациями поддерживающими цели и задачи проекта. Наших участников мы называем кибернетиками.

На данный момент проект разрабатывается в основном общественными силами, постепенно начинается привлечение финансирование и дополнительных сил / ресурсов в проект при помощи разных источников: краудфандинг, краудсорсинг, гранты, инвестиции, которые не ломают суть проекта и т.д.

В рамках нашей работы мы также реализуем образовательные программы. Мы собрали команду студентов-программистов 1-го и 2-го курса средне-специального образовательного учреждения, в котором обучение на программистов ведётся формально, с малыми шансами на успех для выпускников. Мы проводим дополнительное обучение этих студентов и платим им стипендию 1000-4000 руб в мес.

Внимание! Основная часть команды проекта являются "абсолютными коммунячными ватниками", учитывайте это при контактах с нами.

**Присоединяйтесь к нашей работе! Наш девиз: "Все миры будут наши!"**

**Вы можете поучаствовать трудом и поддержать нас финансово через Boosty** https://boosty.to/universo

## Контактная информация и сообщества

**Контактное лицо**, генеральный разнорабочий Владимир Левадный:

- ВКонтакте https://vk.com/vladimirlevadnij
- Телеграм https://t.me/Vladimir_Levadnij
- Электропочта universo.pro@yandex.ru

**Подпишитесь на наши сообщества** и получайте информацию о развитии проекта:

- VK-группа РВМ Универсо https://vk.com/universo_pro
- Telegram-канал РВМ Универсо https://t.me/universo_pro
- YouTube-канал РВМ Универсо https://www.youtube.com/universo_pro
- Дзен-канал РВМ Универсо https://dzen.ru/universo_pro
- Boosty-страница РВМ Универсо https://boosty.to/universo

## Как начать пользоваться?

Заходите на сайт https://universo.pro/, нажимаете на кнопку "В будущее", роботы берут вас за руки и несут в светлое будущее. 

**Внимание! На текущий момент сайт работает в режиме визитки, основной функционал находится в альфа-версии и доступен только разработчикам.**

![image](/uploads/2d1b72ab9f23bf38a5065faa7d3e5afb/image.png)

## Этапы разработки

Ниже представлена краткая информация об этапах разработки РВМ Универсо, как части Омской метаплатформы. Дополнительная информация в [Issues](https://gitlab.com/teknokomo/universo-monorepo/-/issues) (Обсуждениях) в этом репозитории и в рабочей доске Миро.

### Этап 0. Предпроектная работа. 

**Цели:**

- Провести подготовку к запуску проекта, собрать первичную команду кибернетиков (программистов). 
- Собрать требования по функционалу минимально жизнеспособного продукта 2D-фронтенда.
- Создать техническое задание по минимально жизнеспособному продукту 2D-фронтенду.
- Определить технологический стек по минимально жизнеспособному продукту 2D-фронтенду.
- Определение ранее созданных наработок, которые смогут использоваться в проекте, в том числе бэкенд.
- Подготовка программы обучения для участников команды.

**Статус:** `выполнен`.

### Этап 1. Минимально жизнеспособный продукт (MVP) 2D-фронтенда.

**Цели:**

- Провести организацию работы команды кибернетиков, в том числе согласование инструментария и методологий работы, обеспечение участников недостающим инструментарием.
- Запустить обучение участников команды в разных форматах.
- Установить контакты с сообществами поддержки технологий планируемых в технологическом стеке.
- Разработать макеты 2D-фронтенда.
- Развернуть базовый проект на технологическом стеке 2D-фронтенда.
- Соединение 2D-фронтенда по API GraphQL с ранее созданным бэкендом Siriuso.
- Исследование первичных необходимых доработок бэкенда. 
- Создать сайт с базовым функционалом.
- Создать раздел пространств с возможностью создать новое.
- Создать MVP пространств в  2D-фронтенде, в том числе Kanban-доски.
- Подготовить базовую документацию по проекту.
- Провести подготовку к разработке 3D-фронтенда.

**Статус:** `выполнен`.

**По итогам  Этапа 1, так выглядел 2D-фронтенд:**

![image](/uploads/23ec07b1aaf8978046f9fa37e36b6cfc/image.png)

**По итогам  Этапа 1, так выглядел 3D-фронтенд:**

![image](/uploads/570672c3efe601a2f462e2ca0e638b77/image.png)

### Этап 2. Глобальный рефакторинг, оптимизация 2D-фронтенда и MVP 3D-фронтенда.

**Цели:**

- Провести глобальный рефакторинг 2D-фронтенда.
- Провести первичную оптимизацию производительности пространств на 2D-фронтенде.
- Расширить функционал пространств на 2D-фронтенде, в том числе создать примитивные типы контента (текст, стикеры и т.д.).
- Внедрить технологии автоматического тестирование в 2D-фронтенде.
- Добавление в бэкенд необходимых моделей данных, необходимость, которых была выявлена.
- Разделение команды на проекты по 2D-функционалу, 3D-функционалу и бэкенду, определение менеджеров проектов.
- Начало работы по созданию 3D-фронтенда.
- Создание базовых экранов 3D-фронтенда.
- Соединение 3D-фронтенда по API GraphQL с ранее созданным бэкендом Siriuso.
- Создание первичных моделей виртуального-офиса для 3D-фронтенда.
- Создать MVP пространств в 3D-фронтенде, в том числе виртуальный офис.
- Подготовка базовых сценариев для космической MMORPG по мотивам проекта ОМСК-8 (создаваемый в сотрудничестве с фанфиком Вавилон-6).

**Статус:** `в работе`.

### Последующие этапы.

- Формирование различных экономических моделей привлечения финансирования проекта от разных источников: краудфандинг, краудсорсинг, гранты, инвестиции и т.д.
- Развитие функционала гипервселенной метавселенных — глобального каталога метавселенных с разными вариантами их интеграции и взаимодействия.
- Развитие главной Открытой Метавселенной Социальной Кооперации (ОМСК).
- Развитие в 2D-фронтенде функционала аналогичного сервису Miro.com и FigJam / figma.com.
- Развитие в 3D-фронтенде функционала цифровых двойников предприятий и городов, а также функционала MMORPG — открытого бесшовного мира, который начинается с космических локаций и развивается дальше внутрь станций / кораблей, после чего на планеты и т.д.
- Развитие функционала Общественного Кибергосплана.
- Создание абстрактного слоя данных Омской метаплатформы.
- Создание функционала импорта проектов 1С:Предприятия и использование встроенного языка 1С.
- Создание нокоде-функционала.

**Более подробную информацию можно получить в схемах на рабочей доске Миро.**

## Структура проекта

Ознакомьтесь, пожалуйста, с информацией об этом монорепозитории и связанных репозиториях:

- `universo-frontend` - 2D-фронтенд РВМ Универсо разрабатываемый на технологическом стеке: Quasar 2, Phaser 3, Pinia, Apollo, Webpack и т.д.

- `universo-fgd` - 3D-фронтенд РВМ Универсо разрабатываемый на Godot 4.

- `siriuso` - в качестве основного бэкенда для РВМ Универсо сейчас используется бэкенд `Siriuso` на Django 3.X, который находится в отдельном репозитории https://gitlab.com/teknokomo/siriuso.

- `universo-backend` - планируемый бэкенд на Wagtail 5, Django 4.2, PostgreSQL и т.д., но этот проект сейчас мало активен.

- Также планируются `другие виды фронтенда и бэкенда`, на другом технологическом стеке, в том числе на других игровых движках. Вы можете предложить свой технологический стек.

- Сейчас `ведётся разработка учебных суперинтенсивов` по быстрому освоению используемого нами технологического стека и методологий, после тестирования в этом монорепозитории будет создана директория с нашими образовательными материалами.

## Быстрый старт

Информация в разработке, в директориях фронтендов и бэкендов будет загружена информация об их запуске и использовании. Для получения дополнительной информации свяжитесь с контактными лицами.

Внимание! На текущий момент мы не оказываем внешнюю техническую поддержку, мы осуществляем поддержку только для участников команды разработки, к который вы можете присоединиться, если вам интересно развивать этот проект.

## Документация

Мы работаем над созданием единого ресурса документации, больше информации можно найти в [Wiki-проекта](https://gitlab.com/teknokomo/universo-monorepo/-/wikis/home).

## Программы обучения

Мы разрабатываем собственные программы обучения специалистов разного уровня, в том числе с нуля. Как уже было сказано ранее, мы собрали команду студентов-программистов 1-го и 2-го курса средне-специального образовательного учреждения, в котором обучение на программистов ведётся формально, с малыми шансами на успех для выпускников, тем более в современном мире в котором нейросети уже в целом способны заменить специалистов даже уровня выше начального и при определённых обстоятельствах заменить специалистов среднего уровня . 

Мы проводим дополнительное обучение этих студентов и платим им стипендию 1000-4000 руб в мес. На основе этого обучения мы утвердились в изначальном нашем предположении, что любое обучение, чтобы оно было эффективным нужно проводить по методикам суперинтенсивов и сейчас на основе наших наработок мы создаём обучающие и методологические материалы, для запуска регулярных суперинтесивов. 

Все программы будут выложены в открытый доступ, в том числе в этом монорепозитории. Суть разрабатываемых программ суперинтенсивов заключается в насыщенной ежедневной программе обучения с индивидуальным кураторством ментора обучения и каскадной передачи данных, в которой обучающийся становится ментором для других обучающихся и закрепляет свои знания. 

## Лицензия

Все проекты Омской метаплатформы, в том числе части РВМ Универсо, разрабатываются по `Омской открытой лицензии / Гипервселенная модификация`. В частности, это означает, что лицензируемый объект должен использоваться в рамках Общественного Кибергосплана на авторизированных узлах цифровизации гипервселенной. Использование в рамках Общественного Кибергосплана полностью свободно и осуществляется без каких либо ограничений. Лицензия разрешает свободное изучение проекта, в том числе в коммерческих целях.

С полным текстом лицензии вы можете ознакомиться в файле LICENSE.md
