#!/bin/bash
[ "$UID" != 0 ] && { exec sudo bash "$0" && exit 0; }
[[ "$TERM" =~ xterm* ]] && { echo "ОШИБКА: setfont в графической консоли не работает." && ERROR=0; }
command -v yum &>/dev/null || { echo "ОШИБКА: операционная система Fedora не обнаружена." && ERROR=0; }
[ "$ERROR" == 0 ] && exit 0 || echo "Установка шрифта с русскими буквами для консоли Fedora."
# название шрифта, строка для добавления, полный путь к файлу конфигурации
font="LatGrkCyr-8x16" && line="FONT=\"$font\"" && conf="/etc/vconsole.conf"
# установка шрифта и, если успешно, добавление строки со шрифтом в файл конфигурации, если строки нет
if setfont "$font"; then grep -qF "$line" "$conf" || sed -i -E "s|(FONT=.*)$|#\1\n$line|" "$conf"; fi
