#!/bin/bash
[ "$UID" != 0 ] && { exec sudo bash "$0" && exit 0; }
echo "Установка os-prober и base-devel на Arch и обновление меню GRUB."
config="/etc/default/grub" && pacman -S --noconfirm os-prober base-devel
echo "Поиск прочих операционных систем для загрузочного меню GRUB."
sed -i -E 's|^.*(GRUB_DISABLE_OS_PROBER=).*$|\1false|' "$config"
echo "Сохранение последней выбранной строки в загрузочном меню GRUB."
sed -i -E 's|^.*(GRUB_SAVEDEFAULT).*$|\1=true|' "$config"
sed -i -E 's|^(GRUB_DEFAULT).*$|\1=saved|' "$config"
echo "Обновление конфигурации загрузочного меню GRUB."
grub-mkconfig -o /boot/grub/grub.cfg
