#!/bin/bash
[ "$UID" != 0 ] && { exec sudo bash "$0" && exit 0; }
echo "Установка Realtime kernel на Arch и обновление меню GRUB."
kernel="linux-rt" && pacman -Sy --noconfirm "$kernel"
version="$(file -b "$TARGET/boot/vmlinuz-$kernel" | cut -d' ' -f8)"
test -d "$TARGET/usr/lib/modules/$version" || version="rolling"
echo "Установлено ядро операционной системы 'Linux $version'."
mv -f "$TARGET/boot/vmlinuz-$kernel" "$TARGET/boot/vmlinuz-$version"
mv -f "$TARGET/boot/initramfs-$kernel.img" "$TARGET/boot/initramfs-$version.img"
echo "Обновление конфигурации загрузочного меню GRUB."
grub-mkconfig -o /boot/grub/grub.cfg
