#!/bin/bash
echo "Создание каталогов пользователя '$(id -nu $UID)' и копирование файла с указателями."
user_home="$(getent passwd "$(id -nu $UID)" | cut -d':' -f6)"
# создание каталогов пользователя
for folder in Desktop Downloads Templates Public Documents Music Pictures Videos .config; do
  dir="$user_home/$folder" && mkdir -p "$dir" && chown "$UID:$UID" "$dir" && chmod 755 "$dir"
done
# файл с указателями и полный путь
file="$user_home/.config/user-dirs.dirs"
# копирование файла
cat >"$file" <<USERDIRS
# If you want to change or add directories, just edit the line you're
# interested in. All local changes will be retained on the next run.
#
XDG_DESKTOP_DIR="$user_home/Desktop"
XDG_DOWNLOAD_DIR="$user_home/Downloads"
XDG_TEMPLATES_DIR="$user_home/Templates"
XDG_PUBLICSHARE_DIR="$user_home/Public"
XDG_DOCUMENTS_DIR="$user_home/Documents"
XDG_MUSIC_DIR="$user_home/Music"
XDG_PICTURES_DIR="$user_home/Pictures"
XDG_VIDEOS_DIR="$user_home/Videos"
USERDIRS
chown "$UID:$UID" "$file" && chmod 644 "$file"
