#!/bin/bash
[ "$UID" != 0 ] && { exec sudo bash "$0" && exit 0; }
echo "Создание файла политики доступа для pkexec."
# список исполняемых файлов с полными путями к ним
readarray -t list 2>/dev/null <"../any/pkexec.list"
# список установленных приложений
list+=(gnome-system-monitor)
list+=(xfce4-taskmanager)
list+=(xfce4-terminal)
list+=(gnome-disks)
list+=(mousepad)
list+=(baobab)
list+=(thunar)
list+=(btop)
list+=(htop)
# политика доступа
str+="<policyconfig>\n"
str+="<vendor>Custom user policy</vendor>\n"
for app in "${list[@]}"; do
  # полный путь получаем либо из системы, либо из списка
  path="$(command -v "$app" 2>/dev/null || echo "$app")"
  str+="<action id='$path'>\n"
  str+=" <description>Выполнение от суперпользователя</description>\n"
  str+=" <message>Для выполнения '$path' требуется авторизация</message>\n"
  str+=" <defaults>\n"
  str+="  <allow_any>no</allow_any>\n"
  str+="  <allow_inactive>auth_admin</allow_inactive>\n"
  str+="  <allow_active>auth_admin</allow_active>\n"
  str+=" </defaults>\n"
  str+=" <annotate key='org.freedesktop.policykit.exec.path'>$path</annotate>\n"
  str+=" <annotate key='org.freedesktop.policykit.exec.allow_gui'>true</annotate>\n"
  str+="</action>\n"
done
str+="</policyconfig>"
# сохранение в файл
echo -e "$str" >"/usr/share/polkit-1/actions/custom.user.policy"
