#include "common.h"
#include "Frontend.h"
#ifdef PC_MENU

// Please don't touch this file, except for bug fixing or ports.
// Check MenuScreensCustom.cpp

#ifndef CUSTOM_FRONTEND_OPTIONS
CMenuScreen aScreens[] = {
	// MENUPAGE_STATS = 0
	{ "FEH_STA", MENUPAGE_NONE, 3,
		MENUACTION_GOBACK, "FEDS_TB", SAVESLOT_NONE, MENUPAGE_NONE, 190, 320, MENUALIGN_RIGHT,
	},

	// MENUPAGE_NEW_GAME = 1
	{ "FEP_STG", MENUPAGE_NONE, 1,
		MENUACTION_CHANGEMENU, "FES_NGA", SAVESLOT_NONE, MENUPAGE_NEW_GAME_RELOAD, 320, 155, MENUALIGN_CENTER,
		MENUACTION_CHANGEMENU, "FES_LOA",  SAVESLOT_NONE, MENUPAGE_CHOOSE_LOAD_SLOT, 0, 0, MENUALIGN_CENTER,
		MENUACTION_CHANGEMENU, "FES_DEL", SAVESLOT_NONE, MENUPAGE_CHOOSE_DELETE_SLOT, 0, 0, MENUALIGN_CENTER,
		MENUACTION_GOBACK, "FEDS_TB", SAVESLOT_NONE, 0, 0, 0, MENUALIGN_CENTER,
	},

	// MENUPAGE_BRIEFS = 2
	{ "FEH_BRI", MENUPAGE_NONE, 4,
		MENUACTION_GOBACK, "FEDS_TB", SAVESLOT_NONE, MENUPAGE_NONE, 190, 320, MENUALIGN_RIGHT,
	},

	// MENUPAGE_SOUND_SETTINGS = 3
	{ "FEH_AUD", MENUPAGE_OPTIONS, 1,
		MENUACTION_MUSICVOLUME,		"FEA_MUS", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 40, 76, MENUALIGN_LEFT,
		MENUACTION_SFXVOLUME,		"FEA_SFX", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 0, 0, MENUALIGN_LEFT,
		MENUACTION_MP3VOLUMEBOOST,	"FEA_MPB", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 0, 0, MENUALIGN_LEFT,
#ifdef EXTERNAL_3D_SOUND
		MENUACTION_AUDIOHW,			"FEA_3DH", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 0, 0, MENUALIGN_LEFT,
		MENUACTION_SPEAKERCONF,		"FEA_SPK", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 0, 0, MENUALIGN_LEFT,
#endif
		MENUACTION_DYNAMICACOUSTIC,	"FET_DAM", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 0, 0, MENUALIGN_LEFT,
		MENUACTION_RADIO,			"FEA_RSS", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 0, 0, MENUALIGN_LEFT,
#ifdef EXTERNAL_3D_SOUND
		MENUACTION_RESTOREDEF,		"FET_DEF", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 320, 367, MENUALIGN_CENTER,
#else
		MENUACTION_RESTOREDEF,		"FET_DEF", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 320, 327, MENUALIGN_CENTER,
#endif
		MENUACTION_GOBACK,			"FEDS_TB", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, MENUALIGN_CENTER,
	},

	// MENUPAGE_DISPLAY_SETTINGS = 4
#ifdef LEGACY_MENU_OPTIONS
	#define Y_OFFSET 50
#else
	#define Y_OFFSET 0
#endif

	{ "FEH_DIS", MENUPAGE_OPTIONS, 2,
		MENUACTION_BRIGHTNESS,	"FED_BRI", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 78, MENUALIGN_LEFT,
		MENUACTION_DRAWDIST,	"FEM_LOD", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 103, MENUALIGN_LEFT,
#ifdef LEGACY_MENU_OPTIONS
		MENUACTION_FRAMESYNC,	"FEM_VSC", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 128, MENUALIGN_LEFT,
#endif
		MENUACTION_FRAMELIMIT,	"FEM_FRM", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 128 + Y_OFFSET/2, MENUALIGN_LEFT,
#ifdef LEGACY_MENU_OPTIONS
		MENUACTION_TRAILS,		"FED_TRA", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 178, MENUALIGN_LEFT,
#endif
		MENUACTION_SUBTITLES,	"FED_SUB", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 153 + Y_OFFSET, MENUALIGN_LEFT,
		MENUACTION_WIDESCREEN,	"FED_WIS", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 178 + Y_OFFSET, MENUALIGN_LEFT,
		MENUACTION_LEGENDS,		"MAP_LEG", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 202 + Y_OFFSET, MENUALIGN_LEFT,
		MENUACTION_RADARMODE,	"FED_RDR", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 228 + Y_OFFSET, MENUALIGN_LEFT,
		MENUACTION_HUD,			"FED_HUD", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 253 + Y_OFFSET, MENUALIGN_LEFT,
		MENUACTION_SCREENRES,	"FED_RES", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 40, 278 + Y_OFFSET, MENUALIGN_LEFT,
		MENUACTION_RESTOREDEF,	"FET_DEF", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 320, 303 + Y_OFFSET, MENUALIGN_CENTER,
		MENUACTION_GOBACK,		"FEDS_TB", SAVESLOT_NONE, MENUPAGE_NONE, 320, 328 + Y_OFFSET, MENUALIGN_CENTER,
	},

#undef Y_OFFSET

	// MENUPAGE_LANGUAGE_SETTINGS = 5
	{ "FEH_LAN", MENUPAGE_OPTIONS, 3,
		MENUACTION_LANG_ENG,	"FEL_ENG", SAVESLOT_NONE, MENUPAGE_LANGUAGE_SETTINGS, 320, 132, MENUALIGN_CENTER,
		MENUACTION_LANG_FRE,	"FEL_FRE", SAVESLOT_NONE, MENUPAGE_LANGUAGE_SETTINGS, 0, 0, MENUALIGN_CENTER,
		MENUACTION_LANG_GER,	"FEL_GER", SAVESLOT_NONE, MENUPAGE_LANGUAGE_SETTINGS, 0, 0, MENUALIGN_CENTER,
		MENUACTION_LANG_ITA,	"FEL_ITA", SAVESLOT_NONE, MENUPAGE_LANGUAGE_SETTINGS, 0, 0, MENUALIGN_CENTER,
		MENUACTION_LANG_SPA,    "FEL_SPA", SAVESLOT_NONE, MENUPAGE_LANGUAGE_SETTINGS, 0, 0, MENUALIGN_CENTER,
		MENUACTION_GOBACK,		"FEDS_TB", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, MENUALIGN_CENTER,
	},

	// MENUPAGE_MAP = 6
	{ "FEH_MAP", MENUPAGE_NONE, 2,
		 MENUACTION_GOBACK,	"FEDS_TB", SAVESLOT_NONE, MENUPAGE_NONE, 70, 380, MENUALIGN_CENTER,
	},

	// MENUPAGE_NEW_GAME_RELOAD = 7
	{ "FES_NGA", MENUPAGE_NEW_GAME, 0,
		MENUACTION_LABEL,		"FESZ_QR",	SAVESLOT_NONE,	0, 0, 0, 0,
		MENUACTION_NO,			"FEM_NO",	SAVESLOT_NONE,	MENUPAGE_NEW_GAME, 320, 200, MENUALIGN_CENTER,
		MENUACTION_NEWGAME,		"FEM_YES",	SAVESLOT_NONE,	MENUPAGE_NEW_GAME_RELOAD, 320, 225, MENUALIGN_CENTER,
	},

	// MENUPAGE_CHOOSE_LOAD_SLOT = 8
	{ "FET_LG", MENUPAGE_NEW_GAME, 1,
		MENUACTION_CHECKSAVE,	"FEM_SL1", SAVESLOT_1,		0, 40, 90, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL2", SAVESLOT_2,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL3", SAVESLOT_3,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL4", SAVESLOT_4,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL5", SAVESLOT_5,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL6", SAVESLOT_6,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL7", SAVESLOT_7,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL8", SAVESLOT_8,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_GOBACK,		"FEDS_TB", SAVESLOT_NONE,	0, 320, 345, MENUALIGN_CENTER,
	},

	// MENUPAGE_CHOOSE_DELETE_SLOT = 9
	{ "FES_DEL", MENUPAGE_NEW_GAME, 2,
		MENUACTION_CHECKSAVE,	"FEM_SL1",	SAVESLOT_1,		0, 40, 90, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL2",	SAVESLOT_2,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL3",	SAVESLOT_3,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL4",	SAVESLOT_4,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL5",	SAVESLOT_5,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL6",	SAVESLOT_6,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL7",	SAVESLOT_7,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_CHECKSAVE,	"FEM_SL8",	SAVESLOT_8,		0, 0, 0, MENUALIGN_LEFT,
		MENUACTION_GOBACK,		"FEDS_TB",	SAVESLOT_NONE,	0, 320, 345, MENUALIGN_CENTER,
	},

	// MENUPAGE_LOAD_SLOT_CONFIRM = 10
	{ "FET_LG", MENUPAGE_CHOOSE_LOAD_SLOT, 0,
		 MENUACTION_LABEL,		"FESZ_QL",	SAVESLOT_NONE,	0, 0, 0, 0,
		 MENUACTION_NO,			"FEM_NO",	SAVESLOT_NONE,	MENUPAGE_CHOOSE_LOAD_SLOT, 320, 200, MENUALIGN_CENTER,
		 MENUACTION_YES,		"FEM_YES",	SAVESLOT_NONE,	MENUPAGE_LOADING_IN_PROGRESS, 320, 225, MENUALIGN_CENTER,
	},

	// MENUPAGE_DELETE_SLOT_CONFIRM = 11
	{ "FES_DEL", MENUPAGE_CHOOSE_DELETE_SLOT, 0,
		 MENUACTION_LABEL,		"FESZ_QD",	SAVESLOT_NONE,  MENUPAGE_NONE, 0, 0, 0,
		 MENUACTION_NO,			"FEM_NO",	SAVESLOT_NONE,  MENUPAGE_CHOOSE_DELETE_SLOT, 320, 200, MENUALIGN_CENTER,
		 MENUACTION_YES,		"FEM_YES",	SAVESLOT_NONE,	MENUPAGE_DELETING_IN_PROGRESS, 320, 225, MENUALIGN_CENTER,
	},

	// MENUPAGE_LOADING_IN_PROGRESS = 12
	{ "FET_LG", MENUPAGE_CHOOSE_LOAD_SLOT, 0,
	},

	// MENUPAGE_DELETING_IN_PROGRESS = 13
	{ "FES_DEL", MENUPAGE_CHOOSE_DELETE_SLOT, 0,
	},

	// MENUPAGE_DELETE_SUCCESSFUL = 14
	{ "FES_DEL", MENUPAGE_NEW_GAME, 0,
		 MENUACTION_LABEL,		"FES_DSC",	SAVESLOT_NONE,	0, 0, 0, 0,
		 MENUACTION_CHANGEMENU,	"FEM_OK",	SAVESLOT_NONE,	MENUPAGE_NEW_GAME, 320, 225, MENUALIGN_CENTER,
	},

	// MENUPAGE_CHOOSE_SAVE_SLOT = 15
	{ "FET_SG", MENUPAGE_DISABLED, 0,
		MENUACTION_SAVEGAME,			"FEM_SL1", SAVESLOT_1,		MENUPAGE_SAVE_OVERWRITE_CONFIRM, 40, 90, MENUALIGN_LEFT,
		MENUACTION_SAVEGAME,			"FEM_SL2", SAVESLOT_2,		MENUPAGE_SAVE_OVERWRITE_CONFIRM, 0, 0, MENUALIGN_LEFT,
		MENUACTION_SAVEGAME,			"FEM_SL3", SAVESLOT_3,		MENUPAGE_SAVE_OVERWRITE_CONFIRM, 0, 0, MENUALIGN_LEFT,
		MENUACTION_SAVEGAME,			"FEM_SL4", SAVESLOT_4,		MENUPAGE_SAVE_OVERWRITE_CONFIRM, 0, 0, MENUALIGN_LEFT,
		MENUACTION_SAVEGAME,			"FEM_SL5", SAVESLOT_5,		MENUPAGE_SAVE_OVERWRITE_CONFIRM, 0, 0, MENUALIGN_LEFT,
		MENUACTION_SAVEGAME,			"FEM_SL6", SAVESLOT_6,		MENUPAGE_SAVE_OVERWRITE_CONFIRM, 0, 0, MENUALIGN_LEFT,
		MENUACTION_SAVEGAME,			"FEM_SL7", SAVESLOT_7,		MENUPAGE_SAVE_OVERWRITE_CONFIRM, 0, 0, MENUALIGN_LEFT,
		MENUACTION_SAVEGAME,			"FEM_SL8", SAVESLOT_8,		MENUPAGE_SAVE_OVERWRITE_CONFIRM, 0, 0, MENUALIGN_LEFT,
		MENUACTION_RESUME_FROM_SAVEZONE,"FESZ_CA", SAVESLOT_NONE,	0, 320, 345, MENUALIGN_CENTER,
	},

	// MENUPAGE_SAVE_OVERWRITE_CONFIRM = 16
	{ "FET_SG", MENUPAGE_CHOOSE_SAVE_SLOT, 0,
		MENUACTION_LABEL,		"FESZ_QZ", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
		MENUACTION_NO,			"FEM_NO", SAVESLOT_NONE, MENUPAGE_CHOOSE_SAVE_SLOT, 320, 200, MENUALIGN_CENTER,
		MENUACTION_YES,			"FEM_YES",  SAVESLOT_NONE, MENUPAGE_SAVING_IN_PROGRESS, 320, 225, MENUALIGN_CENTER,
	},

	// MENUPAGE_SAVING_IN_PROGRESS = 17
	{ "FET_SG", MENUPAGE_CHOOSE_SAVE_SLOT, 0,
	},

	// MENUPAGE_SAVE_SUCCESSFUL = 18
	{ "FET_SG", MENUPAGE_CHOOSE_SAVE_SLOT, 0,
		MENUACTION_LABEL,					"FES_SSC",	SAVESLOT_LABEL,	MENUPAGE_NONE, 0, 0, 0,
		MENUACTION_RESUME_FROM_SAVEZONE,	"FEM_OK",	SAVESLOT_NONE,	MENUPAGE_CHOOSE_SAVE_SLOT, 320, 225, MENUALIGN_CENTER,
	},

	// MENUPAGE_SAVE_CUSTOM_WARNING = 19
	{ "FET_SG", MENUPAGE_NONE, 0,
		MENUACTION_LABEL,		"",			SAVESLOT_NONE, 0, 0, 0, 0,
		MENUACTION_CHANGEMENU,	"FEM_OK",	SAVESLOT_NONE, MENUPAGE_CHOOSE_SAVE_SLOT, 320, 225, MENUALIGN_CENTER,
	},

	// MENUPAGE_SAVE_CHEAT_WARNING = 20
	{ "FET_SG", MENUPAGE_NEW_GAME, 0,
		MENUACTION_LABEL,		"FES_CHE",	SAVESLOT_NONE,	MENUPAGE_NONE, 0, 0, 0,
		MENUACTION_CHANGEMENU,	"FEM_OK",	SAVESLOT_NONE,	MENUPAGE_CHOOSE_SAVE_SLOT, 320, 225, MENUALIGN_CENTER,
	},

	// MENUPAGE_SKIN_SELECT = 21
	{ "FET_PS", MENUPAGE_OPTIONS, 4,
		 MENUACTION_GOBACK,		"FEDS_TB",	SAVESLOT_NONE, MENUPAGE_OPTIONS, 0, 0, 0,
	},

	// MENUPAGE_SAVE_UNUSED = 22
	{ "FET_SG", MENUPAGE_NEW_GAME, 0,
		 MENUACTION_LABEL,		"FED_LWR",	SAVESLOT_NONE,	0, 0, 0, 0,
		 MENUACTION_CHANGEMENU,	"FEC_OKK",	SAVESLOT_NONE,	MENUPAGE_CHOOSE_SAVE_SLOT, 0, 0, 0,
	},

	// MENUPAGE_SAVE_FAILED = 23
	{ "FET_SG", MENUPAGE_CHOOSE_SAVE_SLOT, 0,
		 MENUACTION_LABEL,		"FEC_SVU",	SAVESLOT_NONE,	0, 0, 0, 0,
		 MENUACTION_CHANGEMENU,	"FEC_OKK",	SAVESLOT_NONE,	MENUPAGE_CHOOSE_SAVE_SLOT, 0, 0, 0,
	},

	// MENUPAGE_SAVE_FAILED_2 = 24
	{ "FET_LG", MENUPAGE_CHOOSE_SAVE_SLOT, 0,
		 MENUACTION_LABEL,		"FEC_SVU",	SAVESLOT_NONE,	0, 0, 0, 0,
	},

	// MENUPAGE_LOAD_FAILED = 25
	{ "FET_LG", MENUPAGE_NEW_GAME, 0,
		 MENUACTION_LABEL,		"FEC_LUN",	SAVESLOT_NONE,  0, 0, 0, 0,
		 MENUACTION_GOBACK,		"FEDS_TB",	SAVESLOT_NONE,  MENUPAGE_NEW_GAME, 0, 0, 0,
	},

	// MENUPAGE_CONTROLLER_PC = 26
	{ "FET_CTL", MENUPAGE_OPTIONS, 0,
#ifdef PC_PLAYER_CONTROLS
		MENUACTION_CTRLMETHOD,	"FET_STI", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC, 320, 150, MENUALIGN_CENTER,
		MENUACTION_KEYBOARDCTRLS,"FEC_RED", SAVESLOT_NONE, MENUPAGE_KEYBOARD_CONTROLS, 0, 0, MENUALIGN_CENTER,
#else
		MENUACTION_KEYBOARDCTRLS,"FEC_RED", SAVESLOT_NONE, MENUPAGE_KEYBOARD_CONTROLS, 320, 150, MENUALIGN_CENTER,
#endif
		MENUACTION_CHANGEMENU,	"FEC_MOU", SAVESLOT_NONE, MENUPAGE_MOUSE_CONTROLS, 0, 0, MENUALIGN_CENTER,
		MENUACTION_RESTOREDEF,	"FET_DEF", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC, 0, 0, MENUALIGN_CENTER,
		MENUACTION_GOBACK,		"FEDS_TB", SAVESLOT_NONE, 0, 0, 0, MENUALIGN_CENTER,
	},

	// MENUPAGE_OPTIONS = 27
	{ "FET_OPT", MENUPAGE_NONE, 5,
		 MENUACTION_CHANGEMENU,		"FEO_CON", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC, 320, 132, MENUALIGN_CENTER,
		 MENUACTION_LOADRADIO,		"FEO_AUD", SAVESLOT_NONE, MENUPAGE_SOUND_SETTINGS, 0, 0, MENUALIGN_CENTER,
		 MENUACTION_CHANGEMENU,		"FEO_DIS", SAVESLOT_NONE, MENUPAGE_DISPLAY_SETTINGS, 0, 0, MENUALIGN_CENTER,
		 MENUACTION_CHANGEMENU,		"FEO_LAN", SAVESLOT_NONE, MENUPAGE_LANGUAGE_SETTINGS, 0, 0, MENUALIGN_CENTER,
		 MENUACTION_PLAYERSETUP,	"FET_PS", SAVESLOT_NONE, MENUPAGE_SKIN_SELECT, 0, 0, MENUALIGN_CENTER,
		 MENUACTION_GOBACK,			"FEDS_TB", SAVESLOT_NONE, 0, 0, 0, MENUALIGN_CENTER,
	},

	// MENUPAGE_EXIT = 28
	{ "FET_QG", MENUPAGE_NONE, 6,
		MENUACTION_LABEL,		"FEQ_SRE",	SAVESLOT_NONE, 0, 0, 0, 0,
		MENUACTION_DONTCANCEL,	"FEM_NO",	SAVESLOT_NONE, MENUPAGE_NONE, 320, 200, MENUALIGN_CENTER,
		MENUACTION_CANCELGAME,	"FEM_YES",	SAVESLOT_NONE, MENUPAGE_NONE, 320, 225, MENUALIGN_CENTER,
	},

	// MENUPAGE_START_MENU = 29
	{ "FEM_MM", MENUPAGE_DISABLED, 0,
		  MENUACTION_CHANGEMENU,	"FEP_STG",	SAVESLOT_NONE,	MENUPAGE_NEW_GAME, 320, 170, MENUALIGN_CENTER,
		  MENUACTION_CHANGEMENU,	"FEP_OPT",	SAVESLOT_NONE,	MENUPAGE_OPTIONS, 0, 0, MENUALIGN_CENTER,
		  MENUACTION_CHANGEMENU,	"FEP_QUI",	SAVESLOT_NONE,	MENUPAGE_EXIT, 0, 0, MENUALIGN_CENTER,
	},
	
	// MENUPAGE_KEYBOARD_CONTROLS = 30
	{ "FET_STI", MENUPAGE_CONTROLLER_PC, 1,
	},

	// MENUPAGE_MOUSE_CONTROLS = 31
	{ "FEC_MOU", MENUPAGE_CONTROLLER_PC, 2,
		MENUACTION_MOUSESENS,	"FEC_MSH",	SAVESLOT_NONE, MENUPAGE_MOUSE_CONTROLS, 40, 170, MENUALIGN_LEFT,
		MENUACTION_INVVERT,		"FEC_IVV",	SAVESLOT_NONE, MENUPAGE_MOUSE_CONTROLS, 0, 0, MENUALIGN_LEFT,
		MENUACTION_MOUSESTEER,	"FET_MST",	SAVESLOT_NONE, MENUPAGE_MOUSE_CONTROLS, 0, 0, MENUALIGN_LEFT,
		MENUACTION_GOBACK,		"FEDS_TB",	SAVESLOT_NONE, 0, 320, 260, MENUALIGN_CENTER,
	},

	// MENUPAGE_PAUSE_MENU = 32
	{ "FET_PAU", MENUPAGE_DISABLED, 0,
		MENUACTION_RESUME,		"FEP_RES",	SAVESLOT_NONE, 0, 320, 120, MENUALIGN_CENTER,
		MENUACTION_CHANGEMENU,	"FEH_SGA",	SAVESLOT_NONE, MENUPAGE_NEW_GAME, 0, 0, MENUALIGN_CENTER,
		MENUACTION_CHANGEMENU,	"FEH_MAP",	SAVESLOT_NONE, MENUPAGE_MAP, 0, 0, MENUALIGN_CENTER,
		MENUACTION_CHANGEMENU,	"FEP_STA",	SAVESLOT_NONE, MENUPAGE_STATS, 0, 0, MENUALIGN_CENTER,
		MENUACTION_CHANGEMENU,	"FEH_BRI",	SAVESLOT_NONE, MENUPAGE_BRIEFS, 0, 0, MENUALIGN_CENTER,
		MENUACTION_CHANGEMENU,	"FET_OPT",	SAVESLOT_NONE, MENUPAGE_OPTIONS, 0, 0, MENUALIGN_CENTER,
		MENUACTION_CHANGEMENU,	"FEP_QUI",	SAVESLOT_NONE, MENUPAGE_EXIT, 0, 0, MENUALIGN_CENTER,
	},

	// MENUPAGE_NONE = 33
	{ "", 0, 0, },

#ifdef LEGACY_MENU_OPTIONS
	// MENUPAGE_DEBUG_MENU
	{ "FED_DBG", MENUPAGE_NONE, 0,
		MENUACTION_RELOADIDE,	"FED_RID", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
		MENUACTION_SETDBGFLAG,	"FED_DFL", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
		MENUACTION_SWITCHBIGWHITEDEBUGLIGHT,	"FED_DLS", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
		MENUACTION_COLLISIONPOLYS,	"FED_SCP", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
		MENUACTION_GOBACK,		"FEDS_TB", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
	},
	
	// MENUPAGE_CONTROLLER_PC_OLD1
	{ "FET_CTL", MENUPAGE_CONTROLLER_PC, 0,
		MENUACTION_GETKEY,	"FEC_PLB", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD1, 0, 0, 0,
		MENUACTION_GETKEY,	"FEC_CWL", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD1, 0, 0, 0,
		MENUACTION_GETKEY,	"FEC_CWR", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD1, 0, 0, 0,
		MENUACTION_GETKEY,	"FEC_LKT", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD1, 0, 0, 0,
		MENUACTION_GETKEY,	"FEC_PJP", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD1, 0, 0, 0,
		MENUACTION_GETKEY,	"FEC_PSP", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD1, 0, 0, 0,
		MENUACTION_GETKEY,	"FEC_TLF", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD1, 0, 0, 0,
		MENUACTION_GETKEY,	"FEC_TRG", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD1, 0, 0, 0,
		MENUACTION_GETKEY,	"FEC_CCM", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD1, 0, 0, 0,
		MENUACTION_GOBACK,		"FEDS_TB", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
	},

	// MENUPAGE_CONTROLLER_PC_OLD2
	{ "FET_CTL", MENUPAGE_CONTROLLER_PC, 1,

	},

	// MENUPAGE_CONTROLLER_PC_OLD3
	{ "FET_CTL", MENUPAGE_CONTROLLER_PC, 2,
		 MENUACTION_GETKEY,	"FEC_LUP", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD3, 0, 0, 0,
		 MENUACTION_GETKEY,	"FEC_LDN", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD3, 0, 0, 0,
		 MENUACTION_GETKEY,	"FEC_SMS", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD3, 0, 0, 0,
		 MENUACTION_SHOWHEADBOB,	"FEC_GSL", SAVESLOT_NONE, MENUPAGE_CONTROLLER_PC_OLD3, 0, 0, 0,
		 MENUACTION_GOBACK,		"FEDS_TB", SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
	},

	// MENUPAGE_CONTROLLER_PC_OLD4
	{ "FET_CTL", MENUPAGE_CONTROLLER_PC, 3,

	},

	// MENUPAGE_CONTROLLER_DEBUG
	{ "FEC_DBG", MENUPAGE_CONTROLLER_PC, 3,
		 MENUACTION_GETKEY,	"FEC_TGD",	SAVESLOT_NONE, MENUPAGE_CONTROLLER_DEBUG, 0, 0, 0,
		 MENUACTION_GETKEY,	"FEC_TDO",	SAVESLOT_NONE, MENUPAGE_CONTROLLER_DEBUG, 0, 0, 0,
		 MENUACTION_GETKEY,	"FEC_TSS",	SAVESLOT_NONE, MENUPAGE_CONTROLLER_DEBUG, 0, 0, 0,
		 MENUACTION_GETKEY,	"FEC_SMS",	SAVESLOT_NONE, MENUPAGE_CONTROLLER_DEBUG, 0, 0, 0,
		 MENUACTION_GOBACK,	"FEDS_TB",	SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
	},
#endif

#ifdef MISSION_REPLAY
	// MENUPAGE_MISSION_RETRY = 57 on mobile

	{ "M_FAIL", MENUPAGE_DISABLED, 0,
		MENUACTION_LABEL,			"FESZ_RM",  SAVESLOT_NONE, MENUPAGE_NONE, 0, 0, 0,
		MENUACTION_CHANGEMENU,		"FEM_YES",  SAVESLOT_NONE, MENUPAGE_LOADING_IN_PROGRESS, 320, 200, MENUALIGN_CENTER,
		MENUACTION_REJECT_RETRY,	"FEM_NO",   SAVESLOT_NONE, MENUPAGE_NONE, 320, 225, MENUALIGN_CENTER,
	},
#endif

	// MENUPAGE_OUTRO - Originally 34
	{ "", 0, 0, },
};

#endif
#endif
