// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0

Item {
    objectName: "States"

    Rectangle {
        id: rectangle
        objectName: "rectangle"
        color: "red"
        anchors { fill: parent; margins: parent.height / 10 }
        states: State {
            name: "blue"
            when: rectangleMouseArea.pressed

            PropertyChanges  { target: rectangle; color: "blue" }
        }
        transitions: [
            Transition {
                to: "blue"

                ColorAnimation { duration: 2000 }
            },
            Transition {
                from: "blue"

                ColorAnimation { duration: 500 }
            }
        ]

        MouseArea {
            id: rectangleMouseArea
            objectName: "rectangleMouseArea"
            anchors.fill: parent
        }
    }
}
