// SPDX-FileCopyrightText: 2023–2025 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    id: page

    DockedPanel {
        id: controlPanel

        width: page.isPortrait ? parent.width : Theme.itemSizeExtraLarge + Theme.paddingLarge
        height: page.isPortrait ? Theme.itemSizeExtraLarge + Theme.paddingLarge : parent.height

        dock: page.isPortrait ? Dock.Top : Dock.Left

        Flow {
            width: isPortrait ? undefined : Theme.itemSizeExtraLarge

            anchors.centerIn: parent

            Switch {
                icon.source: "image://theme/icon-m-shuffle"
            }
            Switch {
                icon.source: "image://theme/icon-m-repeat"
            }
            Switch {
                icon.source: "image://theme/icon-m-share"
            }
        }
    }

    Drawer {
        id: drawer

        anchors.fill: parent
        dock: page.isPortrait ? Dock.Top : Dock.Left

        background: SilicaListView {
            anchors.fill: parent
            model: 5

            header: PageHeader { title: qsTr("Drawer") }

            VerticalScrollDecorator {}

            delegate: ListItem {
                id: listItem

                Label {
                    x: Theme.horizontalPageMargin
                    //% "List Item "
                    text: qsTr("Item ") + modelData
                    anchors.verticalCenter: parent.verticalCenter
                    highlighted: listItem.highlighted
                }
            }
        }

        SilicaFlickable {
            anchors {
                fill: parent
                leftMargin: page.isPortrait ? 0 : controlPanel.visibleSize
                topMargin: page.isPortrait ? controlPanel.visibleSize : 0
            }

            clip: isPortrait && controlPanel.expanded

            contentHeight: column.height + Theme.paddingLarge

            VerticalScrollDecorator {}

            MouseArea {
                enabled: drawer.open
                anchors.fill: column
                onClicked: drawer.open = false
            }

            Column {
                id: column
                spacing: Theme.paddingLarge
                width: parent.width
                enabled: !drawer.opened

                PageHeader { title: qsTr("Panels") }

                Button {
                    text: controlPanel.open ? qsTr("Hide controls") : qsTr("Show controls")
                    onClicked: controlPanel.open = !controlPanel.open
                    anchors.horizontalCenter: parent.horizontalCenter
                }

                Button {
                    text: qsTr("Open drawer")
                    onClicked: drawer.open = true
                    anchors.horizontalCenter: parent.horizontalCenter
                }
            }
        }
    }
}
