// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    PageHeader { title: qsTr("Page %1").arg(pageStack.depth) }
    Column {
        anchors.centerIn: parent
        width: parent.width
        spacing: Theme.paddingLarge

        Button {
            text: qsTr("Push page")
            anchors.horizontalCenter: parent.horizontalCenter
            onClicked:
                pageStack.push(Qt.resolvedUrl("PageStackPage.qml"))
        }
        Button {
            text: qsTr("Pop page")
            anchors.horizontalCenter: parent.horizontalCenter
            onClicked: pageStack.pop()
            enabled: pageStack.depth > 1
        }
        Button {
            text: qsTr("Attach page")
            anchors.horizontalCenter: parent.horizontalCenter
            onClicked: pageStack.pushAttached(Qt.resolvedUrl("PageStackPage.qml"))
        }
        Button {
            text: qsTr("Next page")
            anchors.horizontalCenter: parent.horizontalCenter
            onClicked: pageStack.navigateForward()
        }
        Button {
            text: qsTr("Previous page")
            anchors.horizontalCenter: parent.horizontalCenter
            onClicked: pageStack.navigateBack()
        }
    }
}
