// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    SilicaListView {
        anchors.fill: parent
        header: PageHeader { title: qsTr("ContextMenu") }
        delegate: ListItem {
            menu: ContextMenu {
                MenuItem {
                    text: qsTr("Toggle bold font")
                    onClicked: label.font.bold = !label.font.bold
                }
            }

            Label {
                id: label

                text: qsTr("Item %1").arg(model.index + 1)
                anchors.centerIn: parent
            }
        }
        model: 10
    }
}
