// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    id: page

    PageHeader { title: qsTr("Buttons") }
    Column {
        anchors.centerIn: parent
        spacing: Theme.paddingLarge

        Button {
            anchors.horizontalCenter: parent.horizontalCenter
            text: qsTr("Button")
            onClicked: console.log("Button clicked")
        }
        IconButton {
            anchors.horizontalCenter: parent.horizontalCenter
            icon.source: "image://theme/icon-m-play"
            onClicked: console.log("IconButton clicked")
        }
        ValueButton {
            width: page.width
            label: qsTr("ValueButton")
            description: qsTr("Counting Value")
            value: "0"
            onClicked: value++
        }
    }
}
