// SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0
import Nemo.Notifications 1.0
import Nemo.DBus 2.0

Page {
    objectName: "MainPage"
    allowedOrientations: Orientation.All

    SilicaFlickable {
        anchors.fill: parent
        contentHeight: column.height
        
        Column {
            id: column
            width: page.width
            spacing: Theme.paddingLarge
            PageHeader {
                title: qsTr("Simple Notification")
            }
            Label {
                x: Theme.horizontalPageMargin
                text: notification.replacesId ? qsTr("Notification ID: %1").arg(notification.replacesId)
                : qsTr("Hello!")
                color: Theme.secondaryHighlightColor
                font.pixelSize: Theme.fontSizeExtraLarge
            }
            Button {
                text: "Send notification"
                onClicked: notification.publish()
            }
            Notification {
                id: notification
                icon: "image://theme/icon-lock-information"
                summary: qsTr("Demo")
                body: qsTr("Click me to launch the demo app")
                previewSummary: qsTr("Demo")
                previewBody: qsTr("My notification")
                timestamp: "2024-09-05 20:00:00"
                remoteActions: [
                    {
                        "name": "default",
                        "displayName": "Start",
                        "service": "ru.auroraos.Notifications",
                        "path": "/ru/template/NotificationDemo",
                        "iface": "ru.auroraos.Notifications",
                        "method": "startApp",
                        "icon": "image://theme/icon-s-invitation"
                    }
                ]
            }
        }
    }
    
    DBusAdaptor {
        bus : DBus.SessionBus
        service: "ru.auroraos.Notifications"
        path: "/ru/auroraos/Notifications"
        iface: "ru.auroraos.Notifications"
        xml: ' <interface name="ru.auroraos.Notifications">\n' +
        ' <method name="startApp" />\n' +
        ' </interface>\n'
        
        function startApp() {
            console.log("Connected")
            window.activate()
        }
    }
}
