// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.0
import QtMultimedia 5.6
import QtQuick.Controls 2.4

Item {
    width: 640
    height: 480
    SoundEffect {
        id: soundEffect
        // ToDo: set source to gun.wav in soundeffects folder
        // ToDo: set volume controlled by volumeSlider
        // ToDo: set loops controlled by slider
    }
    MouseArea {
        id: touchHandler
        anchors.fill: parent
        // ToDo: play sound effect or stop playing on clicked
    }
    Column {
        anchors {
            left: parent.left
            right: parent.right
            verticalCenter: parent.verticalCenter
        }
        spacing: 50

        Slider {
            id: volumeSlider
            width: parent.width
            value: 0.5
            from: 0
            to: 1
            stepSize: 0.1
        }
        // ToDo: add slider to control count of loops
        // ToDo: add slider to show progress
    }
}
