// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.0
import QtMultimedia 5.6
import QtQuick.Controls 2.4

Item {
    width: 640
    height: 480
    SoundEffect {
        id: soundEffect
        source: "soundeffects/gun.wav"
        volume: volumeSlider.value
        loops: loopsSlider.value
    }

    Component.onCompleted: {
        console.log(soundEffect.source)
    }
    MouseArea {
        id: touchHandler
        anchors.fill: parent
        onClicked: {
            if (soundEffect.playing)
                soundEffect.stop();
            else
                soundEffect.play();
        }
    }
    Column {
        anchors {
            left: parent.left
            right: parent.right
            verticalCenter: parent.verticalCenter
        }
        spacing: 50

        Label {
            text: qsTr("Volume")
        }

        Slider {
            id: volumeSlider
            width: parent.width
            value: 0.5
            from: 0
            to: 1
            stepSize: 0.1
        }
        Label {
            text: qsTr("Loops")
        }
        Slider {
            id: loopsSlider
            width: parent.width
            value: 1
            from: 1
            to: 10
            stepSize: 1
        }
        Label {
            text: qsTr("Progress")
        }
        Slider {
            width: parent.width
            value: soundEffect.loops - soundEffect.loopsRemaining
            from: 0
            to: loopsSlider.value
            enabled: false
        }
    }
}
