// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.LocalStorage 2.0
import QtQuick.Controls 2.15
import "Database.js" as JS

Window {
    visible: true
    width: Screen.width / 2
    height: Screen.height / 1.8
    title: qsTr("Заметки")

    NoteDialog {
        id: noteDialog
    }

    Column {
        anchors.fill: parent
        ListView {
            id: listView
            width: parent.width
            height: parent.height - button.height
            model: ListModel { id: noteModel }
            delegate: Label {
                text: date + ' ' + note
                anchors.horizontalCenter: parent.horizontalCenter
            }
        }
        Button {
            id: button
            text: qsTr("Добавить")
            anchors.horizontalCenter: parent.horizontalCenter
            onClicked: noteDialog.open()
        }
        Component.onCompleted: {
            JS.dbInit()
            JS.dbReadAll()
            noteDialog.accepted.connect(function() {
                JS.dbInsert(noteDialog.date, noteDialog.note)
                noteModel.append({"date": noteDialog.date, "note": noteDialog.note })
            });
        }
    }
}
