// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.0
import QtQuick.Controls 2.15

Dialog {
    property string date
    property string note
    standardButtons: Dialog.Cancel | Dialog.Ok
    modal: true
    width: 300
    height: 300
    Column {
        id: layout
        objectName: "layout"
        anchors.fill: parent
        TextField {
            id: dateField
            width: parent.width
            placeholderText: qsTr("Введите дату")
        }
        TextArea {
            id: noteField
            width: parent.width
            placeholderText: qsTr("Введите заметку")
        }
    }
    onAccepted: {
        date = dateField.text
        note = noteField.text
    }
}
