// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.0
import Sailfish.Silica 1.0

Dialog {
    objectName: "aboutPage"
    allowedOrientations: Orientation.All
    property string date
    property string note
        Column {
            id: layout
            objectName: "layout"
            anchors.fill: parent

            DialogHeader {
                acceptText: qsTr("Сохранить")
                cancelText: qsTr("Отменить")
            }
            TextField {
                id: dateField
                width: parent.width
                placeholderText: qsTr("Введите дату")
                label: qsTr("Дата заметки")
                EnterKey.iconSource: "image://theme/icon-m-enter-next"
                EnterKey.onClicked: noteField.focus = true
            }
            TextArea {
                id: noteField
                width: parent.width
                placeholderText: qsTr("Введите заметку")
                label: qsTr("Дата заметки")
            }
        }
    onDone: {
        if (result == DialogResult.Accepted) {
            date = dateField.text
            note = noteField.text
        }
    }
}
