// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.0
import Sailfish.Silica 1.0
import QtQuick.LocalStorage 2.0
import "../assets/Database.js" as JS

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    SilicaListView {
        header: PageHeader {
            objectName: "pageHeader"
            title: qsTr("Заметки")
        }
        id: listView
        anchors.fill: parent
        model: ListModel { id: noteModel }
        delegate: ListItem {
                    Label {
                        text: date + ' ' + note
                        anchors.verticalCenter: parent.verticalCenter
                        x: Theme.horizontalPageMargin
                        color: highlighted ? Theme.highlightColor : Theme.primaryColor
                    }
                }
        VerticalScrollDecorator { }

        PullDownMenu {
            MenuItem {
                text: qsTr("Добавить")
                onClicked: {
                    var notePage = pageStack.push(Qt.resolvedUrl("NotePage.qml"))
                    notePage.accepted.connect(function() {
                        JS.dbInsert(notePage.date, notePage.note)
                        noteModel.append({"date": notePage.date, "note": notePage.note })
                    });
                }
            }
        }
    }
    Component.onCompleted: {
        JS.dbInit()
        JS.dbReadAll()
    }
}
