// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0
import Nemo.KeepAlive 1.2

Page {
    id: page
    objectName: "MainPage"

    property var startTime
    property var currentTime
    readonly property string displayStatus: {
        switch (DisplayBlanking.status) {
        case DisplayBlanking.Off: return "off";
        case DisplayBlanking.Dimmed: return "dimmed";
        default: return "on";
        }
    }

    allowedOrientations: Orientation.All

    onDisplayStatusChanged: console.log("Display blanking status:", displayStatus)

    KeepAlive {
        id: keepAlive
        objectName: "keepAlive"
    }

    Timer {
        id: timer
        objectName: "timer"

        property int count: 0

        interval: 1000
        repeat: true

        onTriggered: {
            ++count;
            currentTime = new Date();
        }
    }

    Column {
        objectName: "layout"
        spacing: Theme.paddingLarge
        anchors { left: parent.left; right: parent.right; verticalCenter: parent.verticalCenter }

        TextSwitch {
            text: "Keep Alive"
            onCheckedChanged: {
                startTime = new Date();
                currentTime = new Date();
                timer.count = 0;
                timer.restart();
                keepAlive.enabled = checked;
            }
        }

        Label {
            text: "Duration: %1".arg( Math.round((currentTime.getTime() - startTime.getTime())/1000))
            color: Theme.highlightColor
            anchors.horizontalCenter: parent.horizontalCenter
        }

        Label {
            text: "Timer triggered: %1".arg(timer.count)
            color: Theme.highlightColor
            anchors.horizontalCenter: parent.horizontalCenter
        }

        TextSwitch {
            text: "Prevent blanking"
            onCheckedChanged: DisplayBlanking.preventBlanking = checked
        }

        Label {
            text: "Display is %1".arg(displayStatus)
            color: Theme.highlightColor
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Component.onCompleted: {
        startTime = new Date();
        currentTime = new Date();
        timer.start();
    }
}
