// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0
import Nemo.DBus 2.0

Page {
    objectName: "MainPage"

    Column{
        objectName: "layout"
        anchors.fill: parent

        PageHeader {
            id: header
            objectName: "header"
            title: "D-Bus Services"
        }

        BackgroundItem{
            objectName: "settingsItem"

            DBusInterface {
                id: settingsInterface
                objectName: "settingsInterface"
                service: 'com.jolla.settings'
                path: '/com/jolla/settings/ui'
                iface: 'com.jolla.settings.ui'
            }

            Label{
                objectName: "settingsLabel"
                anchors.centerIn: parent
                text: "Show settings"
            }

            onClicked: settingsInterface.call('showSettings', undefined)
        }

        BackgroundItem{
            objectName: "profileItem"

            DBusInterface {
                id: profileInterface
                objectName: "profileInterface"
                service: "com.nokia.profiled"
                path: "/com/nokia/profiled"
                iface: "com.nokia.profiled"
            }

            Label {
                objectName: "profileLabel"
                anchors.centerIn: parent
                text: "Set silent mode"
            }

            onClicked: profileInterface.call("set_profile", ["silent"]);
        }

        BackgroundItem{
            objectName: "pulseAudioItem"

            DBusInterface {
                id: pulseAudioInterface
                objectName: "pulseAudioInterface"
                service: "org.PulseAudio1"
                path: "/org/pulseaudio/server_lookup1"
                iface: "org.PulseAudio.ServerLookup1"
            }

            Label {
                objectName: "pulseAudioLabel"
                anchors.centerIn: parent
                text: "Get PulseAudio address"
            }

            onClicked: {
                // unix:path=/run/user/100000/pulse/dbus-socket
                var address = pulseAudioInterface.getProperty("Address")
                console.log(address)
            }
        }
    }
}
