// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef VALUESTORAGE_H
#define VALUESTORAGE_H

#include <QObject>

class ValueStorage : public QObject
{
    Q_OBJECT
    Q_PROPERTY(int value READ value WRITE setValue NOTIFY valueChanged)

    public:
        explicit ValueStorage(QObject *parent = nullptr);

        int value() const;

    public slots:
        void setValue(int value);
        void resetValue();

    signals:
        void valueChanged();

    private:
        int m_value;
};

#endif // VALUESTORAGE_H
