// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import ru.auroraos.Counter 1.0

Item {
    id: root
    objectName: "Counter"

    property real fontSize: width / 16

    ValueStorage {
        id: valueStorage
        objectName: "valueStorage"
        onValueChanged: console.log(value)
    }

    Column {
        objectName: "layout"
        width: parent.width

        Text {
            id: valueText
            objectName: "valueText"
            text: "Value: %1".arg(valueStorage.value)
            height: root.height / 3
            verticalAlignment: Text.AlignVCenter
            font.pixelSize: fontSize
            anchors.horizontalCenter: parent.horizontalCenter
        }

        Row {
            objectName: "buttonsRow"
            height: root.height - valueText.height

            MouseArea {
                width: root.width / 2
                height: parent.height

                Text {
                    text: "Increment"
                    anchors.centerIn: parent
                    font.pixelSize: fontSize
                }

                onClicked: valueStorage.value++
            }

            MouseArea {
                width: root.width / 2
                height: parent.height

                Text {
                    text: "Reset"
                    anchors.centerIn: parent
                    font.pixelSize: fontSize
                }

                onClicked: valueStorage.resetValue()
            }
        }
    }
}
