// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include "valuestorage.h"
#include <QDebug>

ValueStorage::ValueStorage(QObject *parent) :
    QObject(parent),
    m_value(0)
{ }

int ValueStorage::value() const
{
    return m_value;
}

void ValueStorage::setValue(int value)
{
    if (m_value == value)
        return;
    m_value = value;
    emit valueChanged();
}

void ValueStorage::resetValue()
{
    setValue(0);
}
