// SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.auroraos.Counter 1.0

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    property real fontSize: width / 16
    
    ValueStorage {
        id: valueStorage
        objectName: "valueStorage"
        onValueChanged: console.log(value)
    }
    
    Column {
        anchors.fill: parent
        
        Label {
            id: valueText
            text: "Value: %1".arg(valueStorage.value)
            verticalAlignment: Text.AlignVCenter
            anchors.horizontalCenter: parent.horizontalCenter
        }
        
        ButtonLayout {
            
            Button {
                text: "Increment"
                onClicked: valueStorage.value++
            }
            
            Button {
                text: "Reset"
                onClicked: valueStorage.resetValue()
            }
        }
    }
}
