// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause
import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    SilicaListView {
        header: PageHeader { title: qsTr("Main Page") }
        anchors.fill: parent
        delegate: ListItem {
            Label {
                anchors.verticalCenter: parent.verticalCenter
                x: Theme.horizontalPageMargin
                color: highlighted ? Theme.highlightColor : Theme.primaryColor
                text: model.name
            }
            onClicked: {
                pageStack.push(Qt.resolvedUrl(model.page + ".qml"))
            }
        }
        model: ListModel {
            ListElement {
                name: qsTr("AppBar")
                page: "AppBarPage"
            }
            ListElement {
                name: qsTr("Popup Menu")
                page: "PopupMenuPage"
            }
            ListElement {
                name: qsTr("SplitView")
                page: "SplitViewPage"
            }
        }
        VerticalScrollDecorator { }
    }
}
