// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    PageHeader {
        objectName: "pageHeader"
        title: qsTr("Animations example")
    }
    Image {
        id: image
        objectName: "image"
        source: Qt.resolvedUrl("../images/aurora.svg")
        fillMode: Image.PreserveAspectFit
        anchors { fill: parent; margins: parent.height / 10 }

        MouseArea {
            objectName: "imageMouseArea"
            anchors.fill: parent

            onClicked: imageAnimation.running = true
        }

        RotationAnimation on rotation {
            id: imageAnimation
            objectName: "imageAnimation"
            to: image.rotation + 360
            duration: 2000
            running: false
        }
    }
}
